/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.common;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.common.Value;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValue<T>
implements Value<T> {
    protected T value;
    protected T normValue;

    public AbstractValue(T value) {
        this.value = value;
        this.normValue = null;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.normValue = null;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public T getNormalizedValue() {
        return this.normValue;
    }

    @Override
    public final boolean isBinary() {
        return this.value instanceof byte[];
    }

    @Override
    public final boolean isNormalized() {
        return this.normValue != null;
    }

    @Override
    public void normalize(Normalizer normalizer) throws NamingException {
        this.normValue = normalizer.normalize(this.value);
    }

    @Override
    public Value<?> clone() throws CloneNotSupportedException {
        return (Value)super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }
}

