/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.util.ArrayUtils;

public abstract class AbstractSchemaObject
implements SchemaObject {
    protected final String oid;
    protected boolean isObsolete = false;
    protected String[] names = ArrayUtils.EMPTY_STRING_ARRAY;
    protected String description;
    protected String schema;

    protected AbstractSchemaObject(String oid) {
        this(oid, ArrayUtils.EMPTY_STRING_ARRAY, false, null);
    }

    protected AbstractSchemaObject(String oid, String[] names) {
        this(oid, names, false, null);
    }

    protected AbstractSchemaObject(String oid, String[] names, boolean isObsolete) {
        this(oid, names, isObsolete, null);
    }

    protected AbstractSchemaObject(String oid, String name, boolean isObsolete) {
        this(oid, new String[]{name}, isObsolete, null);
    }

    protected AbstractSchemaObject(String oid, boolean isObsolete) {
        this(oid, null, isObsolete, null);
    }

    protected AbstractSchemaObject(String oid, String description) {
        this(oid, null, false, description);
    }

    protected AbstractSchemaObject(String oid, String[] names, boolean isObsolete, String description) {
        if (oid == null) {
            throw new NullPointerException("oid cannot be null");
        }
        this.oid = oid;
        this.isObsolete = isObsolete;
        this.description = description;
        if (names != null) {
            this.names = names;
        }
    }

    public String getOid() {
        return this.oid;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.names == null || this.names.length == 0 ? null : this.names[0];
    }

    public String getDescription() {
        return this.description;
    }

    protected void setObsolete(boolean obsolete) {
        this.isObsolete = obsolete;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    protected void setNames(String[] names) {
        this.names = names;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SchemaObject) {
            return this.oid.equals(((SchemaObject)obj).getOid());
        }
        return false;
    }

    public String toString() {
        return "<" + this.oid + ", " + (this.names == null || this.names.length == 0 ? "null" : this.names[0]) + ">";
    }
}

