/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Map;
import org.apache.directory.shared.ldap.aci.ReusableAntlrACIItemChecker;
import org.apache.directory.shared.ldap.aci.ReusableAntlrACIItemCheckerLexer;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;

public class ACIItemChecker {
    private ReusableAntlrACIItemChecker checker;
    private ReusableAntlrACIItemCheckerLexer lexer = new ReusableAntlrACIItemCheckerLexer(new StringReader(""));
    private final boolean isNormalizing;

    public ACIItemChecker() {
        this.checker = new ReusableAntlrACIItemChecker(this.lexer);
        this.checker.init();
        this.isNormalizing = false;
    }

    public ACIItemChecker(NameComponentNormalizer normalizer, Map oidsMap) {
        this.checker = new ReusableAntlrACIItemChecker(this.lexer);
        this.checker.setNormalizer(normalizer);
        this.checker.init();
        this.isNormalizing = true;
    }

    private synchronized void reset(String spec) {
        StringReader in = new StringReader(spec);
        this.lexer.prepareNextInput(in);
        this.checker.resetState();
    }

    public synchronized void parse(String spec) throws ParseException {
        if (spec == null || spec.trim().equals("")) {
            return;
        }
        this.reset(spec);
        try {
            this.checker.wrapperEntryPoint();
        }
        catch (TokenStreamException e) {
            String msg = "Parser failure on ACIItem:\n\t" + spec;
            msg = msg + "\nAntlr exception trace:\n" + e.getMessage();
            throw new ParseException(msg, 0);
        }
        catch (RecognitionException e) {
            String msg = "Parser failure on ACIItem:\n\t" + spec;
            msg = msg + "\nAntlr exception trace:\n" + e.getMessage();
            throw new ParseException(msg, e.getColumn());
        }
    }

    public boolean isNormizing() {
        return this.isNormalizing;
    }
}

