/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.util.ByteBuffer;
import org.apache.directory.shared.ldap.util.Position;

public class StringTools {
    static String defaultCharset = null;
    private static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int UTF8_MULTI_BYTES_MASK = 128;
    private static final int UTF8_TWO_BYTES_MASK = 224;
    private static final int UTF8_TWO_BYTES = 192;
    private static final int UTF8_THREE_BYTES_MASK = 240;
    private static final int UTF8_THREE_BYTES = 224;
    private static final int UTF8_FOUR_BYTES_MASK = 248;
    private static final int UTF8_FOUR_BYTES = 240;
    private static final int UTF8_FIVE_BYTES_MASK = 252;
    private static final int UTF8_FIVE_BYTES = 248;
    private static final int UTF8_SIX_BYTES_MASK = 254;
    private static final int UTF8_SIX_BYTES = 252;
    public static final boolean[] ALPHA;
    public static final boolean[] CHAR;
    public static final boolean[] DIGIT;
    private static final boolean[] HEX;
    public static final byte[] HEX_VALUE;
    public static final char[] LOWER_CASE;
    private static final int CHAR_ONE_BYTE_MASK = -128;
    private static final int CHAR_TWO_BYTES_MASK = -2048;
    private static final int CHAR_THREE_BYTES_MASK = -65536;
    private static final int CHAR_FOUR_BYTES_MASK = -2097152;
    private static final int CHAR_FIVE_BYTES_MASK = -67108864;
    private static final int CHAR_SIX_BYTES_MASK = Integer.MIN_VALUE;
    public static final int NOT_EQUAL = -1;
    public static final String EMPTY = "";
    public static final byte[] EMPTY_BYTES;
    static /* synthetic */ Class class$0;

    static {
        boolean[] blArray = new boolean[128];
        blArray[65] = true;
        blArray[66] = true;
        blArray[67] = true;
        blArray[68] = true;
        blArray[69] = true;
        blArray[70] = true;
        blArray[71] = true;
        blArray[72] = true;
        blArray[73] = true;
        blArray[74] = true;
        blArray[75] = true;
        blArray[76] = true;
        blArray[77] = true;
        blArray[78] = true;
        blArray[79] = true;
        blArray[80] = true;
        blArray[81] = true;
        blArray[82] = true;
        blArray[83] = true;
        blArray[84] = true;
        blArray[85] = true;
        blArray[86] = true;
        blArray[87] = true;
        blArray[88] = true;
        blArray[89] = true;
        blArray[90] = true;
        blArray[97] = true;
        blArray[98] = true;
        blArray[99] = true;
        blArray[100] = true;
        blArray[101] = true;
        blArray[102] = true;
        blArray[103] = true;
        blArray[104] = true;
        blArray[105] = true;
        blArray[106] = true;
        blArray[107] = true;
        blArray[108] = true;
        blArray[109] = true;
        blArray[110] = true;
        blArray[111] = true;
        blArray[112] = true;
        blArray[113] = true;
        blArray[114] = true;
        blArray[115] = true;
        blArray[116] = true;
        blArray[117] = true;
        blArray[118] = true;
        blArray[119] = true;
        blArray[120] = true;
        blArray[121] = true;
        blArray[122] = true;
        ALPHA = blArray;
        boolean[] blArray2 = new boolean[128];
        blArray2[45] = true;
        blArray2[48] = true;
        blArray2[49] = true;
        blArray2[50] = true;
        blArray2[51] = true;
        blArray2[52] = true;
        blArray2[53] = true;
        blArray2[54] = true;
        blArray2[55] = true;
        blArray2[56] = true;
        blArray2[57] = true;
        blArray2[65] = true;
        blArray2[66] = true;
        blArray2[67] = true;
        blArray2[68] = true;
        blArray2[69] = true;
        blArray2[70] = true;
        blArray2[71] = true;
        blArray2[72] = true;
        blArray2[73] = true;
        blArray2[74] = true;
        blArray2[75] = true;
        blArray2[76] = true;
        blArray2[77] = true;
        blArray2[78] = true;
        blArray2[79] = true;
        blArray2[80] = true;
        blArray2[81] = true;
        blArray2[82] = true;
        blArray2[83] = true;
        blArray2[84] = true;
        blArray2[85] = true;
        blArray2[86] = true;
        blArray2[87] = true;
        blArray2[88] = true;
        blArray2[89] = true;
        blArray2[90] = true;
        blArray2[97] = true;
        blArray2[98] = true;
        blArray2[99] = true;
        blArray2[100] = true;
        blArray2[101] = true;
        blArray2[102] = true;
        blArray2[103] = true;
        blArray2[104] = true;
        blArray2[105] = true;
        blArray2[106] = true;
        blArray2[107] = true;
        blArray2[108] = true;
        blArray2[109] = true;
        blArray2[110] = true;
        blArray2[111] = true;
        blArray2[112] = true;
        blArray2[113] = true;
        blArray2[114] = true;
        blArray2[115] = true;
        blArray2[116] = true;
        blArray2[117] = true;
        blArray2[118] = true;
        blArray2[119] = true;
        blArray2[120] = true;
        blArray2[121] = true;
        blArray2[122] = true;
        CHAR = blArray2;
        boolean[] blArray3 = new boolean[128];
        blArray3[48] = true;
        blArray3[49] = true;
        blArray3[50] = true;
        blArray3[51] = true;
        blArray3[52] = true;
        blArray3[53] = true;
        blArray3[54] = true;
        blArray3[55] = true;
        blArray3[56] = true;
        blArray3[57] = true;
        DIGIT = blArray3;
        boolean[] blArray4 = new boolean[128];
        blArray4[48] = true;
        blArray4[49] = true;
        blArray4[50] = true;
        blArray4[51] = true;
        blArray4[52] = true;
        blArray4[53] = true;
        blArray4[54] = true;
        blArray4[55] = true;
        blArray4[56] = true;
        blArray4[57] = true;
        blArray4[65] = true;
        blArray4[66] = true;
        blArray4[67] = true;
        blArray4[68] = true;
        blArray4[69] = true;
        blArray4[70] = true;
        blArray4[97] = true;
        blArray4[98] = true;
        blArray4[99] = true;
        blArray4[100] = true;
        blArray4[101] = true;
        blArray4[102] = true;
        HEX = blArray4;
        byte[] byArray = new byte[112];
        byArray[0] = -1;
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -1;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = -1;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[49] = 1;
        byArray[50] = 2;
        byArray[51] = 3;
        byArray[52] = 4;
        byArray[53] = 5;
        byArray[54] = 6;
        byArray[55] = 7;
        byArray[56] = 8;
        byArray[57] = 9;
        byArray[58] = -1;
        byArray[59] = -1;
        byArray[60] = -1;
        byArray[61] = -1;
        byArray[62] = -1;
        byArray[63] = -1;
        byArray[64] = -1;
        byArray[65] = 10;
        byArray[66] = 11;
        byArray[67] = 12;
        byArray[68] = 13;
        byArray[69] = 14;
        byArray[70] = 15;
        byArray[71] = -1;
        byArray[72] = -1;
        byArray[73] = -1;
        byArray[74] = -1;
        byArray[75] = -1;
        byArray[76] = -1;
        byArray[77] = -1;
        byArray[78] = -1;
        byArray[79] = -1;
        byArray[80] = -1;
        byArray[81] = -1;
        byArray[82] = -1;
        byArray[83] = -1;
        byArray[84] = -1;
        byArray[85] = -1;
        byArray[86] = -1;
        byArray[87] = -1;
        byArray[88] = -1;
        byArray[89] = -1;
        byArray[90] = -1;
        byArray[91] = -1;
        byArray[92] = -1;
        byArray[93] = -1;
        byArray[94] = -1;
        byArray[95] = -1;
        byArray[96] = -1;
        byArray[97] = 10;
        byArray[98] = 11;
        byArray[99] = 12;
        byArray[100] = 13;
        byArray[101] = 14;
        byArray[102] = 15;
        byArray[103] = -1;
        byArray[104] = -1;
        byArray[105] = -1;
        byArray[106] = -1;
        byArray[107] = -1;
        byArray[108] = -1;
        byArray[109] = -1;
        byArray[110] = -1;
        byArray[111] = -1;
        HEX_VALUE = byArray;
        char[] cArray = new char[192];
        cArray[45] = 45;
        cArray[48] = 48;
        cArray[49] = 49;
        cArray[50] = 50;
        cArray[51] = 51;
        cArray[52] = 52;
        cArray[53] = 53;
        cArray[54] = 54;
        cArray[55] = 55;
        cArray[56] = 56;
        cArray[57] = 57;
        cArray[65] = 97;
        cArray[66] = 98;
        cArray[67] = 99;
        cArray[68] = 100;
        cArray[69] = 101;
        cArray[70] = 102;
        cArray[71] = 103;
        cArray[72] = 104;
        cArray[73] = 105;
        cArray[74] = 106;
        cArray[75] = 107;
        cArray[76] = 108;
        cArray[77] = 109;
        cArray[78] = 110;
        cArray[79] = 111;
        cArray[80] = 112;
        cArray[81] = 113;
        cArray[82] = 114;
        cArray[83] = 115;
        cArray[84] = 116;
        cArray[85] = 117;
        cArray[86] = 118;
        cArray[87] = 119;
        cArray[88] = 120;
        cArray[89] = 121;
        cArray[90] = 122;
        cArray[97] = 97;
        cArray[98] = 98;
        cArray[99] = 99;
        cArray[100] = 100;
        cArray[101] = 101;
        cArray[102] = 102;
        cArray[103] = 103;
        cArray[104] = 104;
        cArray[105] = 105;
        cArray[106] = 106;
        cArray[107] = 107;
        cArray[108] = 108;
        cArray[109] = 109;
        cArray[110] = 110;
        cArray[111] = 111;
        cArray[112] = 112;
        cArray[113] = 113;
        cArray[114] = 114;
        cArray[115] = 115;
        cArray[116] = 116;
        cArray[117] = 117;
        cArray[118] = 118;
        cArray[119] = 119;
        cArray[120] = 120;
        cArray[121] = 121;
        cArray[122] = 122;
        LOWER_CASE = cArray;
        EMPTY_BYTES = new byte[0];
    }

    public static final String trimConsecutiveToOne(String str, char ch) {
        if (str == null || str.length() == 0) {
            return EMPTY;
        }
        char[] buffer = str.toCharArray();
        char[] newbuf = new char[buffer.length];
        int pos = 0;
        boolean same = false;
        int i = 0;
        while (i < buffer.length) {
            char car = buffer[i];
            if (car == ch) {
                if (!same) {
                    same = true;
                    newbuf[pos++] = car;
                }
            } else {
                same = false;
                newbuf[pos++] = car;
            }
            ++i;
        }
        return new String(newbuf, 0, pos);
    }

    public static final String deepTrim(String string) {
        return StringTools.deepTrim(string, false);
    }

    public static final String deepTrimToLower(String string) {
        return StringTools.deepTrim(string, true);
    }

    public static final String deepTrim(String str, boolean toLowerCase) {
        if (str == null || str.length() == 0) {
            return EMPTY;
        }
        char[] buf = str.toCharArray();
        char[] newbuf = new char[buf.length];
        boolean wsSeen = false;
        boolean isStart = true;
        int pos = 0;
        int i = 0;
        while (i < str.length()) {
            char ch = buf[i];
            if (toLowerCase && Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            }
            if (Character.isWhitespace(ch)) {
                if (!wsSeen) {
                    wsSeen = true;
                    if (isStart) {
                        isStart = false;
                    } else {
                        newbuf[pos++] = ch;
                    }
                }
            } else {
                wsSeen = false;
                isStart = false;
                newbuf[pos++] = ch;
            }
            ++i;
        }
        return pos == 0 ? EMPTY : new String(newbuf, 0, wsSeen ? pos - 1 : pos);
    }

    public static final String centerTrunc(String str, int head, int tail) {
        StringBuffer buf = null;
        if (str.length() <= head + tail + 7 + str.length() / 10) {
            return str;
        }
        buf = new StringBuffer();
        buf.append('[').append(str.length()).append("][");
        buf.append(str.substring(0, head)).append("...");
        buf.append(str.substring(str.length() - tail));
        buf.append(']');
        return buf.toString();
    }

    public static final String toHexString(byte[] res) {
        StringBuffer buf = new StringBuffer(res.length << 1);
        int ii = 0;
        while (ii < res.length) {
            String digit = Integer.toHexString(0xFF & res[ii]);
            if (digit.length() == 1) {
                digit = String.valueOf('0') + digit;
            }
            buf.append(digit);
            ++ii;
        }
        return buf.toString().toUpperCase();
    }

    public static final String toLowerCase(String value) {
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            chars[i] = LOWER_CASE[chars[i]];
            ++i;
        }
        return new String(chars);
    }

    public static final byte[] toByteArray(String hexString) {
        int arrLength = hexString.length() >> 1;
        byte[] buf = new byte[arrLength];
        int ii = 0;
        while (ii < arrLength) {
            int index = ii << 1;
            String l_digit = hexString.substring(index, index + 2);
            buf[ii] = (byte)Integer.parseInt(l_digit, 16);
            ++ii;
        }
        return buf;
    }

    public static final String formatHtml(String source, boolean replaceNl, boolean replaceTag, boolean replaceQuote) {
        StringBuffer buf = new StringBuffer();
        int len = source.length();
        int ii = 0;
        while (ii < len) {
            char ch = source.charAt(ii);
            switch (ch) {
                case '\"': {
                    if (replaceQuote) {
                        buf.append("&quot;");
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case '<': {
                    if (replaceTag) {
                        buf.append("&lt;");
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case '>': {
                    if (replaceTag) {
                        buf.append("&gt;");
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case '\n': {
                    if (replaceNl) {
                        if (replaceTag) {
                            buf.append("&lt;br&gt;");
                            break;
                        }
                        buf.append("<br>");
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case '\r': {
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++ii;
        }
        return buf.toString();
    }

    public static final Pattern getRegex(String initialPattern, String[] anyPattern, String finalPattern) throws PatternSyntaxException {
        StringBuffer buf = new StringBuffer();
        if (initialPattern != null) {
            buf.append('^').append(initialPattern);
        }
        if (anyPattern != null) {
            int i = 0;
            while (i < anyPattern.length) {
                buf.append(".*").append(anyPattern[i]);
                ++i;
            }
        }
        if (finalPattern != null) {
            buf.append(".*").append(finalPattern);
        } else {
            buf.append(".*");
        }
        return Pattern.compile(buf.toString());
    }

    public static final Pattern getRegex(String ldapRegex) throws PatternSyntaxException {
        if (ldapRegex == null) {
            throw new PatternSyntaxException("Regex was null", "null", -1);
        }
        ArrayList<String> any = new ArrayList<String>();
        String remaining = ldapRegex;
        int index = remaining.indexOf(42);
        if (index == -1) {
            throw new PatternSyntaxException("Ldap regex must have wild cards!", remaining, -1);
        }
        String initialPattern = null;
        if (remaining.charAt(0) != '*') {
            initialPattern = remaining.substring(0, index);
        }
        remaining = remaining.substring(index + 1, remaining.length());
        while ((index = remaining.indexOf(42)) != -1) {
            any.add(remaining.substring(0, index));
            remaining = remaining.substring(index + 1, remaining.length());
        }
        String finalPattern = null;
        if (!remaining.endsWith("*") && remaining.length() > 0) {
            finalPattern = remaining;
        }
        if (any.size() > 0) {
            String[] anyStrs = new String[any.size()];
            int i = 0;
            while (i < anyStrs.length) {
                anyStrs[i] = (String)any.get(i);
                ++i;
            }
            return StringTools.getRegex(initialPattern, anyStrs, finalPattern);
        }
        return StringTools.getRegex(initialPattern, null, finalPattern);
    }

    /*
     * Unable to fully structure code
     */
    public static final List getPaths(String paths, FileFilter filter) {
        max = paths.length() - 1;
        start = 0;
        stop = -1;
        path = null;
        list = new ArrayList<String>();
        if (paths != null && !paths.trim().equals("")) ** GOTO lbl19
        return list;
lbl-1000:
        // 1 sources

        {
            stop = paths.indexOf(File.pathSeparatorChar, start);
            if (stop == -1) {
                if (start >= max || (path = paths.substring(start)).trim().equals("") || filter != null && !filter.accept(new File(path))) break;
                list.add(path);
                break;
            }
            path = paths.substring(start, stop);
            if (!path.trim().equals("") && (filter == null || filter.accept(new File(path)))) {
                list.add(path);
            }
            start = stop + 1;
lbl19:
            // 2 sources

            ** while (start < max)
        }
lbl20:
        // 3 sources

        return list;
    }

    public static final String dumpByte(byte octet) {
        return new String(new byte[]{48, 120, HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]});
    }

    public static final char dumpHex(byte hex) {
        return (char)HEX_CHAR[hex & 0xF];
    }

    public static final String dumpBytes(byte[] buffer) {
        if (buffer == null) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buffer.length) {
            sb.append("0x").append((char)HEX_CHAR[(buffer[i] & 0xF0) >> 4]).append((char)HEX_CHAR[buffer[i] & 0xF]).append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static String dumpObject(Object object) {
        if (object != null) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof byte[]) {
                return StringTools.dumpBytes((byte[])object);
            }
            return "<unknown type>";
        }
        return EMPTY;
    }

    public static final String dumpHexPairs(byte[] buffer) {
        if (buffer == null) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < buffer.length) {
            sb.append((char)HEX_CHAR[(buffer[i] & 0xF0) >> 4]).append((char)HEX_CHAR[buffer[i] & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public static final char bytesToChar(byte[] bytes) {
        return StringTools.bytesToChar(bytes, 0);
    }

    public static final int countBytesPerChar(byte[] bytes, int pos) {
        if (bytes == null) {
            return -1;
        }
        if ((bytes[pos] & 0x80) == 0) {
            return 1;
        }
        if ((bytes[pos] & 0xE0) == 192) {
            return 2;
        }
        if ((bytes[pos] & 0xF0) == 224) {
            return 3;
        }
        if ((bytes[pos] & 0xF8) == 240) {
            return 4;
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return 5;
        }
        if ((bytes[pos] & 0xFE) == 252) {
            return 6;
        }
        return -1;
    }

    public static final int countNbBytesPerChar(char car) {
        if ((car & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((car & 0xFFFFF800) == 0) {
            return 2;
        }
        if ((car & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((car & 0xFFE00000) == 0) {
            return 4;
        }
        if ((car & 0xFC000000) == 0) {
            return 5;
        }
        if ((car & Integer.MIN_VALUE) == 0) {
            return 6;
        }
        return -1;
    }

    public static final int countBytes(char[] chars) {
        if (chars == null) {
            return 0;
        }
        int nbBytes = 0;
        int currentPos = 0;
        while (currentPos < chars.length) {
            int nbb;
            currentPos += (nbb = StringTools.countNbBytesPerChar(chars[currentPos])) < 4 ? 1 : 2;
            nbBytes += nbb;
        }
        return nbBytes;
    }

    public static final char bytesToChar(byte[] bytes, int pos) {
        if (bytes == null) {
            return '\uffff';
        }
        if ((bytes[pos] & 0x80) == 0) {
            return (char)bytes[pos];
        }
        if ((bytes[pos] & 0xE0) == 192) {
            return (char)(((bytes[pos] & 0x1C) << 6) + ((bytes[pos] & 3) << 6) + (bytes[pos + 1] & 0x3F));
        }
        if ((bytes[pos] & 0xF0) == 224) {
            return (char)(((bytes[pos] & 0xF) << 12) + ((bytes[pos + 1] & 0x3C) << 6) + ((bytes[pos + 1] & 3) << 6) + (bytes[pos + 2] & 0x3F));
        }
        if ((bytes[pos] & 0xF8) == 240) {
            return (char)(((bytes[pos] & 7) << 18) + ((bytes[pos + 1] & 0x30) << 16) + ((bytes[pos + 1] & 0xF) << 12) + ((bytes[pos + 2] & 0x3C) << 6) + ((bytes[pos + 2] & 3) << 6) + (bytes[pos + 3] & 0x3F));
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return (char)(((bytes[pos] & 3) << 24) + ((bytes[pos + 1] & 0x3F) << 18) + ((bytes[pos + 2] & 0x30) << 12) + ((bytes[pos + 2] & 0xF) << 12) + ((bytes[pos + 3] & 0x3C) << 6) + ((bytes[pos + 3] & 3) << 6) + (bytes[pos + 4] & 0x3F));
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return (char)(((bytes[pos] & 1) << 30) + ((bytes[pos + 1] & 0x3F) << 24) + ((bytes[pos + 2] & 0x3F) << 18) + ((bytes[pos + 3] & 0x30) << 12) + ((bytes[pos + 3] & 0xF) << 12) + ((bytes[pos + 4] & 0x3C) << 6) + ((bytes[pos + 4] & 3) << 6) + (bytes[pos + 5] & 0x3F));
        }
        return '\uffff';
    }

    public static final byte[] charToBytes(char car) {
        byte[] bytes = new byte[StringTools.countNbBytesPerChar(car)];
        if (car <= '\u007f') {
            bytes[0] = (byte)car;
            return bytes;
        }
        if (car <= '\u07ff') {
            bytes[0] = (byte)(192 + ((car & 0x7C0) >> 6));
            bytes[1] = (byte)(128 + (car & 0x3F));
        } else {
            bytes[0] = (byte)(224 + ((car & 0xF000) >> 12));
            bytes[1] = (byte)(128 + ((car & 0xFC0) >> 6));
            bytes[2] = (byte)(128 + (car & 0x3F));
        }
        return bytes;
    }

    public static final int countChars(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int nbChars = 0;
        int currentPos = 0;
        while (currentPos < bytes.length) {
            currentPos += StringTools.countBytesPerChar(bytes, currentPos);
            ++nbChars;
        }
        return nbChars;
    }

    public static final int areEquals(byte[] byteArray, int index, String text) {
        if (byteArray == null || byteArray.length == 0 || byteArray.length <= index || index < 0 || text == null) {
            return -1;
        }
        try {
            byte[] data = text.getBytes("UTF-8");
            return StringTools.areEquals(byteArray, index, data);
        }
        catch (UnsupportedEncodingException uee) {
            return -1;
        }
    }

    public static final int areEquals(char[] charArray, int index, String text) {
        if (charArray == null || charArray.length == 0 || charArray.length <= index || index < 0 || text == null) {
            return -1;
        }
        char[] data = text.toCharArray();
        return StringTools.areEquals(charArray, index, data);
    }

    public static final int areEquals(char[] charArray, int index, char[] charArray2) {
        if (charArray == null || charArray.length == 0 || charArray.length <= index || index < 0 || charArray2 == null || charArray2.length == 0 || charArray2.length > charArray.length + index) {
            return -1;
        }
        int i = 0;
        while (i < charArray2.length) {
            if (charArray[index++] != charArray2[i]) {
                return -1;
            }
            ++i;
        }
        return index;
    }

    public static final boolean areEquals(String string1, int index, String text) {
        int length1 = string1.length();
        int length2 = text.length();
        if (string1 == null || length1 == 0 || length1 <= index || index < 0 || text == null || length2 == 0 || length2 > length1 + index) {
            return false;
        }
        return string1.substring(index).startsWith(text);
    }

    public static final int areEquals(byte[] byteArray, int index, byte[] byteArray2) {
        if (byteArray == null || byteArray.length == 0 || byteArray.length <= index || index < 0 || byteArray2 == null || byteArray2.length == 0 || byteArray2.length > byteArray.length + index) {
            return -1;
        }
        int i = 0;
        while (i < byteArray2.length) {
            if (byteArray[index++] != byteArray2[i]) {
                return -1;
            }
            ++i;
        }
        return index;
    }

    public static final boolean isCharASCII(byte[] byteArray, int index, char car) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return byteArray[index] == car;
    }

    public static final boolean isCharASCII(char[] chars, int index, char car) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] == car;
    }

    public static final boolean isCharASCII(String string, int index, char car) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        return string.charAt(index) == car;
    }

    public static final char charAt(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return '\u0000';
        }
        return string.charAt(index);
    }

    public static final boolean isHex(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        byte c = byteArray[index];
        return c <= 127 && HEX[c];
    }

    public static final boolean isHex(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        char c = chars[index];
        return c <= '\u007f' && HEX[c];
    }

    public static final boolean isHex(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && HEX[c];
    }

    public static final boolean isDigit(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return false;
        }
        return byteArray[0] <= 127 && DIGIT[byteArray[0]];
    }

    public static final boolean isDigit(char car) {
        return car >= '0' && car <= '9';
    }

    public static final boolean isAlphaASCII(byte[] byteArray, int index) {
        byte c;
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return (c = byteArray[index++]) <= 127 && ALPHA[c];
    }

    public static final boolean isAlphaASCII(char[] chars, int index) {
        char c;
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return (c = chars[index++]) <= '\u007f' && ALPHA[c];
    }

    public static final boolean isAlphaASCII(String string, int index) {
        char c;
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        return (c = string.charAt(index++)) <= '\u007f' && ALPHA[c];
    }

    public static final boolean isDigit(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return byteArray[index] <= 127 && DIGIT[byteArray[index]];
    }

    public static final boolean isDigit(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] <= '\u007f' && DIGIT[chars[index]];
    }

    public static final boolean isDigit(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && DIGIT[c];
    }

    public static final boolean isDigit(char[] chars) {
        if (chars == null || chars.length == 0) {
            return false;
        }
        return chars[0] <= '\u007f' && DIGIT[chars[0]];
    }

    public static final boolean isAlphaDigitMinus(byte[] byteArray, int index) {
        byte c;
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return (c = byteArray[index++]) <= 127 && CHAR[c];
    }

    public static final boolean isAlphaDigitMinus(char[] chars, int index) {
        char c;
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return (c = chars[index++]) <= '\u007f' && CHAR[c];
    }

    public static final boolean isAlphaDigitMinus(String string, int index) {
        char c;
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        return (c = string.charAt(index++)) <= '\u007f' && CHAR[c];
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static final boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static final String trim(String str) {
        return StringTools.isEmpty(str) ? EMPTY : str.trim();
    }

    public static final byte[] trim(byte[] bytes) {
        if (StringTools.isEmpty(bytes)) {
            return EMPTY_BYTES;
        }
        int start = StringTools.trimLeft(bytes, 0);
        int end = StringTools.trimRight(bytes, bytes.length - 1);
        int length = end - start + 1;
        if (length != 0) {
            byte[] newBytes = new byte[end - start + 1];
            System.arraycopy(bytes, start, newBytes, 0, length);
            return newBytes;
        }
        return EMPTY_BYTES;
    }

    public static final String trimLeft(String str) {
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        int start = 0;
        int end = str.length();
        while (start < end && str.charAt(start) == ' ') {
            ++start;
        }
        return start == 0 ? str : str.substring(start);
    }

    /*
     * Unable to fully structure code
     */
    public static final int trimLeft(char[] chars, int pos) {
        if (chars != null) ** GOTO lbl4
        return pos;
lbl-1000:
        // 1 sources

        {
            ++pos;
lbl4:
            // 2 sources

            ** while (pos < chars.length && chars[pos] == ' ')
        }
lbl5:
        // 1 sources

        return pos;
    }

    public static final void trimLeft(String string, Position pos) {
        if (string == null) {
            return;
        }
        int length = string.length();
        while (pos.start < length && string.charAt(pos.start) == ' ') {
            ++pos.start;
        }
        pos.end = pos.start;
    }

    /*
     * Unable to fully structure code
     */
    public static final int trimLeft(byte[] bytes, int pos) {
        if (bytes != null) ** GOTO lbl4
        return pos;
lbl-1000:
        // 1 sources

        {
            ++pos;
lbl4:
            // 2 sources

            ** while (pos < bytes.length && bytes[pos] == 32)
        }
lbl5:
        // 1 sources

        return pos;
    }

    public static final String trimRight(String str) {
        int length;
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        int end = length = str.length();
        while (end > 0 && str.charAt(end - 1) == ' ') {
            if (end > 1 && str.charAt(end - 2) == '\\') break;
            --end;
        }
        return end == length ? str : str.substring(0, end);
    }

    public static final String trimRight(String str, int escapedSpace) {
        int length;
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        int end = length = str.length();
        while (end > 0 && str.charAt(end - 1) == ' ' && end > escapedSpace) {
            if (end > 1 && str.charAt(end - 2) == '\\') break;
            --end;
        }
        return end == length ? str : str.substring(0, end);
    }

    /*
     * Unable to fully structure code
     */
    public static final int trimRight(char[] chars, int pos) {
        if (chars != null) ** GOTO lbl4
        return pos;
lbl-1000:
        // 1 sources

        {
            --pos;
lbl4:
            // 2 sources

            ** while (pos >= 0 && chars[pos - 1] == ' ')
        }
lbl5:
        // 1 sources

        return pos;
    }

    /*
     * Unable to fully structure code
     */
    public static final String trimRight(String string, Position pos) {
        if (string != null) ** GOTO lbl5
        return "";
        while (pos.end <= 1 || string.charAt(pos.end - 2) != '\\') {
            --pos.end;
lbl5:
            // 2 sources

            if (pos.end >= 0 && string.charAt(pos.end - 1) == ' ') continue;
        }
        return pos.end == string.length() ? string : string.substring(0, pos.end);
    }

    /*
     * Unable to fully structure code
     */
    public static final int trimRight(byte[] bytes, int pos) {
        if (bytes != null) ** GOTO lbl4
        return pos;
lbl-1000:
        // 1 sources

        {
            --pos;
lbl4:
            // 2 sources

            ** while (pos >= 0 && bytes[pos] == 32)
        }
lbl5:
        // 1 sources

        return pos;
    }

    public static final String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static final String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static final boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static final String utf8ToString(byte[] bytes) {
        if (bytes == null) {
            return EMPTY;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return EMPTY;
        }
    }

    public static final String utf8ToString(byte[] bytes, int length) {
        if (bytes == null) {
            return EMPTY;
        }
        try {
            return new String(bytes, 0, length, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return EMPTY;
        }
    }

    public static final byte[] getBytesUtf8(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new byte[0];
        }
    }

    public static final String listToString(List list) {
        if (list == null || list.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public static final String listToString(List list, String tabs) {
        if (list == null || list.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(tabs);
            sb.append(iter.next());
            sb.append('\n');
        }
        return sb.toString();
    }

    public static final String mapToString(Map map) {
        if (map == null || map.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            Object key = iter.next();
            sb.append(key);
            sb.append(" = '").append(map.get(key)).append("'");
        }
        return sb.toString();
    }

    public static final String mapToString(Map map, String tabs) {
        if (map == null || map.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            sb.append(tabs);
            sb.append(key);
            Object value = map.get(key);
            sb.append(" = '").append(value.toString()).append("'\n");
        }
        return sb.toString();
    }

    public static final String getDefaultCharsetName() {
        if (defaultCharset == null) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.nio.charset.Charset");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Method method = clazz.getMethod("defaultCharset", new Class[0]);
                defaultCharset = ((Charset)method.invoke(null, new Object[0])).name();
            }
            catch (Exception e) {
                defaultCharset = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            }
        }
        return defaultCharset;
    }

    public static final String decodeHexString(String str) throws InvalidNameException {
        if (str == null || str.length() == 0) {
            throw new InvalidNameException("Expected string to start with a '#' character.  Invalid hex encoded string for empty or null string.");
        }
        char[] chars = str.toCharArray();
        if (chars[0] != '#') {
            throw new InvalidNameException("Expected string to start with a '#' character.  Invalid hex encoded string: " + str);
        }
        byte[] decoded = new byte[chars.length - 1 >> 1];
        int ii = 1;
        int jj = 0;
        while (ii < chars.length) {
            int ch = (HEX_VALUE[chars[ii]] << 4) + HEX_VALUE[chars[ii + 1]];
            decoded[jj] = (byte)ch;
            ii += 2;
            ++jj;
        }
        return StringTools.utf8ToString(decoded);
    }

    public static final String decodeEscapedHex(String str) throws InvalidNameException {
        int length = str.length();
        if (str == null || length == 0) {
            throw new InvalidNameException("Expected string to be non-empty or non-null with valid index.");
        }
        StringBuffer buf = new StringBuffer();
        ByteBuffer bb = new ByteBuffer();
        int ii = 0;
        while (ii < length) {
            if (str.charAt(ii) == '\\') {
                if (StringTools.isHex(str, ii + 1) && StringTools.isHex(str, ii + 2)) {
                    bb.clear();
                    int advancedBy = StringTools.collectEscapedHexBytes(bb, str, ii);
                    ii += advancedBy - 1;
                    buf.append(StringTools.utf8ToString(bb.buffer(), bb.position()));
                } else {
                    buf.append(str.charAt(ii));
                }
            } else {
                buf.append(str.charAt(ii));
            }
            ++ii;
        }
        return buf.toString();
    }

    private static int collectEscapedHexBytes(ByteBuffer bb, String str, int index) {
        int advanceBy = 0;
        int ii = index;
        while (ii < str.length()) {
            if (!StringTools.isHex(str, ii + 1) || !StringTools.isHex(str, ii + 2)) break;
            int bite = (HEX_VALUE[str.charAt(ii + 1)] << 4) + HEX_VALUE[str.charAt(ii + 2)];
            bb.append(bite);
            ii += 3;
            advanceBy += 3;
        }
        return advanceBy;
    }

    public static String asciiBytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY;
        }
        char[] result = new char[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = (char)bytes[i];
            ++i;
        }
        return new String(result);
    }
}

