/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;

public class PropertiesUtils {
    private static final String DOTPROPERTIES = ".properties";

    public static Properties findUserProperties(String filename) {
        return PropertiesUtils.findProperties(new File(System.getProperty("user.home")), filename);
    }

    public static Properties findProperties(File dir, String filename) {
        File asis = new File(dir, filename);
        if (asis.exists()) {
            return PropertiesUtils.getProperties(asis);
        }
        if (filename.endsWith(DOTPROPERTIES)) {
            String noExt = filename.substring(0, filename.length() - 11);
            if (new File(dir, noExt).exists()) {
                return PropertiesUtils.getProperties(new File(dir, noExt));
            }
            return new Properties();
        }
        File withExt = new File(dir, String.valueOf(filename) + DOTPROPERTIES);
        if (withExt.exists()) {
            return PropertiesUtils.getProperties(withExt);
        }
        return new Properties();
    }

    public static Properties getStaticProperties(Class ref) {
        Properties properties = new Properties();
        String address = ref.toString().replace('.', '/');
        String path = String.valueOf(address) + DOTPROPERTIES;
        InputStream input = ref.getResourceAsStream(path);
        if (input != null) {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                return properties;
            }
        }
        return properties;
    }

    public static Properties getStaticProperties(Class ref, String path) {
        Properties properties = new Properties();
        InputStream input = ref.getResourceAsStream(path);
        if (input == null) {
            return properties;
        }
        try {
            properties.load(input);
        }
        catch (IOException e) {
            return properties;
        }
        return properties;
    }

    public static Properties getProperties(File file) {
        Properties properties = new Properties();
        if (file == null) {
            return properties;
        }
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException e) {
                return properties;
            }
        }
        return properties;
    }

    public static Properties getProperties(ClassLoader classloader, String path) {
        Properties properties = new Properties();
        InputStream input = classloader.getResourceAsStream(path);
        if (input != null) {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                return properties;
            }
        }
        return properties;
    }

    public static Properties getProperties(Class clazz, String path) {
        Properties properties = new Properties();
        InputStream input = clazz.getResourceAsStream(path);
        if (input != null) {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                return properties;
            }
        }
        return properties;
    }

    public static void macroExpand(Properties expanded, Properties[] optionals) {
        if (optionals == null) {
            optionals = new Properties[]{};
        }
        Enumeration<?> list = expanded.propertyNames();
        block0: while (list.hasMoreElements()) {
            int m;
            String key = (String)list.nextElement();
            String macro = expanded.getProperty(key);
            int n = macro.indexOf("${");
            if (n < 0 || (m = macro.indexOf("}", n + 2)) < 0) continue;
            String symbol = macro.substring(n + 2, m);
            if (expanded.containsKey(symbol)) {
                String value = expanded.getProperty(symbol);
                String head = macro.substring(0, n);
                String tail = macro.substring(m + 1);
                String resolved = String.valueOf(head) + value + tail;
                expanded.put(key, resolved);
                continue;
            }
            int ii = 0;
            while (ii < optionals.length) {
                if (optionals[ii].containsKey(symbol)) {
                    String value = optionals[ii].getProperty(symbol);
                    String head = macro.substring(0, n);
                    String tail = macro.substring(m + 1);
                    String resolved = String.valueOf(head) + value + tail;
                    expanded.put(key, resolved);
                    continue block0;
                }
                ++ii;
            }
        }
    }

    public static String discover(String key, Properties[] sources, boolean haltOnDiscovery) {
        String retval = null;
        int ii = 0;
        while (ii < sources.length) {
            if (sources[ii].containsKey(key)) {
                retval = sources[ii].getProperty(key);
                if (haltOnDiscovery) break;
            }
            ++ii;
        }
        return retval;
    }

    public static void discover(Properties keys, Properties[] sources, boolean haltOnDiscovery) {
        if (sources == null || keys == null) {
            return;
        }
        Iterator<Object> list = keys.keySet().iterator();
        while (list.hasNext()) {
            String key = (String)list.next();
            String value = PropertiesUtils.discover(key, sources, haltOnDiscovery);
            if (value == null) continue;
            keys.setProperty(key, value);
        }
    }

    public static boolean get(Properties props, String key, boolean defaultValue) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return defaultValue;
        }
        String val = props.getProperty(key).trim().toLowerCase();
        return val.equals("true") || val.equals("on") || val.equals("1") || val.equals("yes");
    }

    public static int get(Hashtable ht, Object key, int defval) {
        if (ht == null || !ht.containsKey(key) || ht.get(key) == null) {
            return defval;
        }
        Object obj = ht.get(key);
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Long) {
            return ((Long)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (NumberFormatException ne) {
                ne.printStackTrace();
                return defval;
            }
        }
        return defval;
    }

    public static long get(Properties props, String key, long defaultValue) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return defaultValue;
        }
        throw new NotImplementedException();
    }

    public static byte get(Properties props, String key, byte defaultValue) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return defaultValue;
        }
        throw new NotImplementedException();
    }

    public static char get(Properties props, String key, char defaultValue) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return defaultValue;
        }
        throw new NotImplementedException();
    }

    public static Set fill(Properties props, String key, Set values) {
        if (values == null) {
            values = new HashSet();
        }
        return (Set)PropertiesUtils.fillCollection(props, key, values, " ");
    }

    public static Set fill(Properties props, String key, Set values, String delimiter) {
        if (values == null) {
            values = new HashSet();
        }
        return (Set)PropertiesUtils.fillCollection(props, key, values, delimiter);
    }

    public static List fill(Properties props, String key, List values) {
        if (values == null) {
            values = new ArrayList();
        }
        return (List)PropertiesUtils.fillCollection(props, key, values, " ");
    }

    public static List fill(Properties props, String key, List values, String delimiter) {
        if (values == null) {
            values = new ArrayList();
        }
        return (List)PropertiesUtils.fillCollection(props, key, values, delimiter);
    }

    public static Collection fillCollection(Properties props, String key, Collection values, String delimiter) {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            return values;
        }
        String[] items = props.getProperty(key).trim().split(delimiter);
        int ii = 0;
        while (ii < items.length) {
            values.add(items[ii]);
            ++ii;
        }
        return values;
    }

    public static Attributes fillAttributes(Properties props, String key, Attributes values) throws NamingException {
        if (props == null || !props.containsKey(key) || props.getProperty(key) == null) {
            if (values == null) {
                return new LockableAttributesImpl();
            }
            return values;
        }
        String ldif = props.getProperty(key).trim().replace('*', '\n');
        LdifReader ldifReader = new LdifReader(new StringReader(ldif));
        Entry entry = (Entry)ldifReader.next();
        if (entry != null) {
            values = entry.getAttributes();
        }
        return values;
    }
}

