/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.ArrayList;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class NamespaceTools {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isRoot(String a_dn) throws InvalidNameException {
        if (a_dn == null) {
            throw new InvalidNameException("A null DN is not a valid name.");
        }
        if (a_dn.indexOf(61) == -1) {
            throw new InvalidNameException("A DN should have an = sign.");
        }
        return a_dn.indexOf(44) == -1;
    }

    public static String getParent(String a_childDN) throws InvalidNameException {
        int l_index = -1;
        if (a_childDN == null) {
            throw new InvalidNameException("A null DN is not a valid name.");
        }
        if (a_childDN.indexOf(61) == -1) {
            throw new InvalidNameException("A DN should have an = sign.");
        }
        l_index = a_childDN.indexOf(44);
        if (l_index == -1) {
            return null;
        }
        return a_childDN.substring(l_index + 1);
    }

    public static String getNamespaceString(Name a_name) throws InvalidNameException {
        if (a_name instanceof CompositeName) {
            if (a_name.size() > 1) {
                throw new InvalidNameException(String.valueOf(a_name.toString()) + " has more components than namespace can handle");
            }
            return a_name.get(0);
        }
        return a_name.toString();
    }

    public static String getNamespaceString(String a_base, Name a_name) throws InvalidNameException {
        if (a_name instanceof CompositeName) {
            if (a_name.size() > 1) {
                throw new InvalidNameException(String.valueOf(a_name.toString()) + " has more components than namespace can handle");
            }
            StringBuffer l_buf = new StringBuffer(a_base);
            l_buf.append(',');
            l_buf.append(a_name.get(0));
            return l_buf.toString();
        }
        return a_name.toString();
    }

    public static String getLastComponent(String a_name) {
        if (a_name == null) {
            return null;
        }
        int l_commaIndex = -1;
        l_commaIndex = a_name.lastIndexOf(44);
        if (l_commaIndex == -1) {
            return a_name;
        }
        return a_name.substring(l_commaIndex);
    }

    public static String getRdn(String a_name) {
        if (a_name == null) {
            return null;
        }
        int l_commaIndex = -1;
        l_commaIndex = a_name.indexOf(44);
        if (l_commaIndex == -1) {
            return a_name;
        }
        return a_name.substring(0, l_commaIndex);
    }

    public static String setRdn(String a_name, String a_rdn) {
        if (a_name == null) {
            return null;
        }
        int l_commaIndex = -1;
        l_commaIndex = a_name.indexOf(44);
        if (l_commaIndex == -1) {
            return a_name;
        }
        StringBuffer l_suffix = new StringBuffer();
        l_suffix.append(a_name.substring(l_commaIndex, a_name.length()));
        l_suffix.insert(0, a_rdn);
        return l_suffix.toString();
    }

    public static String getRdnAttribute(String a_rdn) {
        int l_index = a_rdn.indexOf(61);
        return a_rdn.substring(0, l_index);
    }

    public static String getRdnValue(String a_rdn) {
        int l_index = a_rdn.indexOf(61);
        return a_rdn.substring(l_index + 1, a_rdn.length());
    }

    public static boolean isSibling(Name a_name1, Name a_name2) {
        if (a_name1.size() == a_name2.size()) {
            return a_name2.startsWith(a_name1.getPrefix(1));
        }
        return false;
    }

    public static boolean isDescendant(Name a_ancestor, Name a_descendant) {
        return a_descendant.startsWith(a_ancestor);
    }

    public static Name getRelativeName(Name ancestor, Name descendant) throws NamingException {
        LdapDN rdn = null;
        rdn = descendant instanceof LdapDN ? (LdapDN)descendant.clone() : new LdapDN(descendant.toString());
        if (rdn.startsWith(ancestor)) {
            int ii = 0;
            while (ii < ancestor.size()) {
                rdn.remove(0);
                ++ii;
            }
        } else {
            NamingException e = new NamingException(descendant + " is not ancestually related to context:" + ancestor);
            throw e;
        }
        return rdn;
    }

    public static String inferLdapName(String realm) {
        if (StringTools.isEmpty(realm)) {
            return "";
        }
        StringBuffer buf = new StringBuffer(realm.length());
        buf.append("dc=");
        int start = 0;
        int end = 0;
        while ((end = realm.indexOf(46, start)) != -1) {
            buf.append(realm.substring(start, end)).append(",dc=");
            start = end + 1;
        }
        buf.append(realm.substring(start));
        return buf.toString();
    }

    public static String[] getCompositeComponents(String compositeNameComponent) throws NamingException {
        int lastIndex = compositeNameComponent.length() - 1;
        ArrayList<String> comps = new ArrayList<String>();
        int ii = compositeNameComponent.length() - 1;
        while (ii >= 0) {
            if (compositeNameComponent.charAt(ii) == '+') {
                if (ii == 0) {
                    throw new NamingException("invalid name - a name cannot start with a '+': " + compositeNameComponent);
                }
                if (compositeNameComponent.charAt(ii - 1) != '\\') {
                    if (lastIndex == compositeNameComponent.length() - 1) {
                        comps.add(0, compositeNameComponent.substring(ii + 1, lastIndex + 1));
                    } else {
                        comps.add(0, compositeNameComponent.substring(ii + 1, lastIndex));
                    }
                    lastIndex = ii;
                }
            }
            if (ii == 0) {
                if (lastIndex == compositeNameComponent.length() - 1) {
                    comps.add(0, compositeNameComponent);
                } else {
                    comps.add(0, compositeNameComponent.substring(ii, lastIndex));
                }
                lastIndex = 0;
            }
            --ii;
        }
        if (comps.size() == 0) {
            comps.add(compositeNameComponent);
        }
        return comps.toArray(EMPTY_STRING_ARRAY);
    }

    public static boolean hasCompositeComponents(String name) throws NamingException {
        int ii = name.length() - 1;
        while (ii >= 0) {
            if (name.charAt(ii) == '+') {
                if (ii == 0) {
                    throw new NamingException("invalid name - a name cannot start with a '+': " + name);
                }
                if (name.charAt(ii - 1) != '\\') {
                    return true;
                }
            }
            --ii;
        }
        return false;
    }

    public String toLowerAttributeType(String nameComponent) throws NamingException {
        String attr = null;
        String value = null;
        StringBuffer buf = new StringBuffer();
        if (NamespaceTools.hasCompositeComponents(nameComponent)) {
            String[] comps = NamespaceTools.getCompositeComponents(nameComponent);
            int ii = 0;
            while (ii < comps.length) {
                attr = NamespaceTools.getRdnAttribute(nameComponent);
                value = NamespaceTools.getRdnValue(nameComponent);
                buf.append(attr.toLowerCase());
                buf.append("=");
                buf.append(value);
                if (ii != comps.length - 1) {
                    buf.append("+");
                }
                ++ii;
            }
            return buf.toString();
        }
        attr = NamespaceTools.getRdnAttribute(nameComponent);
        value = NamespaceTools.getRdnValue(nameComponent);
        buf.append(attr.toLowerCase());
        buf.append("=");
        buf.append(value);
        return buf.toString();
    }
}

