/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.directory.shared.ldap.util.ComponentsMonitor;
import org.apache.directory.shared.ldap.util.MandatoryComponentsMonitor;
import org.apache.directory.shared.ldap.util.OptionalComponentsMonitor;

public class MandatoryAndOptionalComponentsMonitor
implements ComponentsMonitor {
    private ComponentsMonitor mandatoryComponentsMonitor;
    private ComponentsMonitor optionalComponentsMonitor;

    public MandatoryAndOptionalComponentsMonitor(String[] mandatoryComponents, String[] optionalComponents) throws IllegalArgumentException {
        int i = 0;
        while (i < mandatoryComponents.length) {
            int j = 0;
            while (j < optionalComponents.length) {
                if (mandatoryComponents[i].equals(optionalComponents[j])) {
                    throw new IllegalArgumentException("Common element, \"" + mandatoryComponents[i] + "\" detected for Mandatory and Optional components.");
                }
                ++j;
            }
            ++i;
        }
        this.mandatoryComponentsMonitor = new MandatoryComponentsMonitor(mandatoryComponents);
        this.optionalComponentsMonitor = new OptionalComponentsMonitor(optionalComponents);
    }

    public ComponentsMonitor useComponent(String component) {
        try {
            this.mandatoryComponentsMonitor.useComponent(component);
        }
        catch (IllegalArgumentException e1) {
            try {
                this.optionalComponentsMonitor.useComponent(component);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("Unregistered or previously used component: " + component);
            }
        }
        return this;
    }

    public boolean allComponentsUsed() {
        return this.mandatoryComponentsMonitor.allComponentsUsed() && this.optionalComponentsMonitor.allComponentsUsed();
    }

    public boolean finalStateValid() {
        return this.mandatoryComponentsMonitor.finalStateValid() && this.optionalComponentsMonitor.finalStateValid();
    }

    public List getRemainingComponents() {
        LinkedList remainingComponents = new LinkedList();
        remainingComponents.addAll(this.mandatoryComponentsMonitor.getRemainingComponents());
        remainingComponents.addAll(this.optionalComponentsMonitor.getRemainingComponents());
        return Collections.unmodifiableList(remainingComponents);
    }
}

