/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.ldap.util.Base64;

public class LdifUtils {
    private static boolean[] LDIF_SAFE_STARTING_CHAR_ALPHABET = new boolean[128];
    private static boolean[] LDIF_SAFE_OTHER_CHARS_ALPHABET = new boolean[128];

    static {
        int i = 0;
        while (i < 128) {
            LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[i] = true;
            ++i;
        }
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[13] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[32] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[58] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[60] = false;
        i = 0;
        while (i < 128) {
            LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[i] = true;
            ++i;
        }
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[13] = false;
    }

    public static boolean isLDIFSafe(String str) {
        char currentChar = str.charAt(0);
        if (currentChar > '\u007f' || !LDIF_SAFE_STARTING_CHAR_ALPHABET[currentChar]) {
            return false;
        }
        int i = 1;
        while (i < str.length()) {
            currentChar = str.charAt(i);
            if (currentChar > '\u007f' || !LDIF_SAFE_OTHER_CHARS_ALPHABET[currentChar]) {
                return false;
            }
            ++i;
        }
        return currentChar != ' ';
    }

    public static String convertToLdif(Attributes attrs) throws NamingException {
        StringBuffer sb = new StringBuffer();
        NamingEnumeration<? extends Attribute> ne = attrs.getAll();
        while (ne.hasMore()) {
            Attribute attribute = ne.next();
            if (!(attribute instanceof Attribute)) continue;
            sb.append(LdifUtils.convertToLdif(attribute));
        }
        return sb.toString();
    }

    private static String convertToLdif(Attribute attr) throws NamingException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < attr.size()) {
            StringBuffer lineBuffer = new StringBuffer();
            lineBuffer.append(attr.getID());
            Object value = attr.get(i);
            if (value instanceof byte[]) {
                char[] encoded = Base64.encode((byte[])value);
                lineBuffer.append(":: " + new String(encoded));
            } else if (value instanceof String) {
                String str = (String)value;
                if (!LdifUtils.isLDIFSafe(str)) {
                    char[] encoded = Base64.encode(((String)value).getBytes());
                    lineBuffer.append(":: " + new String(encoded));
                } else {
                    lineBuffer.append(": " + value);
                }
            }
            lineBuffer.append("\n");
            sb.append(LdifUtils.stripLineToNChars(lineBuffer.toString(), 80));
            ++i;
        }
        return sb.toString();
    }

    public static String stripLineToNChars(String str, int nbChars) {
        int strLength = str.length();
        if (strLength <= nbChars) {
            return str;
        }
        if (nbChars < 2) {
            throw new IllegalArgumentException("The length of each line must be at least 2 chars long");
        }
        int charsPerLine = nbChars - 1;
        int remaining = (strLength - nbChars) % charsPerLine;
        int nbLines = 1 + (strLength - nbChars) / charsPerLine + (remaining == 0 ? 0 : 1);
        int nbCharsTotal = strLength + nbLines + nbLines - 2;
        char[] buffer = new char[nbCharsTotal];
        char[] orig = str.toCharArray();
        int posSrc = 0;
        int posDst = 0;
        System.arraycopy(orig, posSrc, buffer, posDst, nbChars);
        posSrc += nbChars;
        posDst += nbChars;
        int i = 0;
        while (i < nbLines - 2) {
            buffer[posDst++] = 10;
            buffer[posDst++] = 32;
            System.arraycopy(orig, posSrc, buffer, posDst, charsPerLine);
            posSrc += charsPerLine;
            posDst += charsPerLine;
            ++i;
        }
        buffer[posDst++] = 10;
        buffer[posDst++] = 32;
        System.arraycopy(orig, posSrc, buffer, posDst, remaining == 0 ? charsPerLine : remaining);
        return new String(buffer);
    }
}

