/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.StringTools;

public class SubstringNode
extends LeafNode {
    private final String initialPattern;
    private final String finalPattern;
    private final List anyPattern;
    private transient Pattern regex = null;

    public SubstringNode(String attribute, String initialPattern, String finalPattern) {
        super(attribute, 2);
        this.anyPattern = new ArrayList(2);
        this.finalPattern = finalPattern;
        this.initialPattern = initialPattern;
    }

    public SubstringNode(ArrayList anyPattern, String attribute, String initialPattern, String finalPattern) {
        super(attribute, 2);
        this.anyPattern = anyPattern;
        this.finalPattern = finalPattern;
        this.initialPattern = initialPattern;
    }

    public final String getInitial() {
        return this.initialPattern;
    }

    public final String getFinal() {
        return this.finalPattern;
    }

    public final List getAny() {
        return this.anyPattern;
    }

    public final Pattern getRegex(Normalizer normalizer) throws PatternSyntaxException, NamingException {
        if (this.regex != null) {
            return this.regex;
        }
        if (this.anyPattern.size() > 0) {
            String[] any = new String[this.anyPattern.size()];
            int i = 0;
            while (i < any.length) {
                any[i] = (String)normalizer.normalize(this.anyPattern.get(i));
                if (any[i].length() == 0) {
                    any[i] = " ";
                }
                ++i;
            }
            String initialStr = null;
            if (this.initialPattern != null) {
                initialStr = (String)normalizer.normalize(this.initialPattern);
            }
            String finalStr = null;
            if (this.finalPattern != null) {
                finalStr = (String)normalizer.normalize(this.finalPattern);
            }
            return StringTools.getRegex(initialStr, any, finalStr);
        }
        String initialStr = null;
        if (this.initialPattern != null) {
            initialStr = (String)normalizer.normalize(this.initialPattern);
        }
        String finalStr = null;
        if (this.finalPattern != null) {
            finalStr = (String)normalizer.normalize(this.finalPattern);
        }
        return StringTools.getRegex(initialStr, null, finalStr);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.printToBuffer(buf);
        return buf.toString();
    }

    public StringBuffer printToBuffer(StringBuffer buf) {
        buf.append('(').append(this.getAttribute()).append('=');
        if (this.initialPattern != null) {
            buf.append(this.initialPattern).append('*');
        } else {
            buf.append('*');
        }
        int i = 0;
        while (i < this.anyPattern.size()) {
            buf.append(this.anyPattern.get(i).toString());
            buf.append('*');
            ++i;
        }
        if (this.finalPattern != null) {
            buf.append(this.finalPattern);
        }
        buf.append(')');
        if (this.getAnnotations() != null && this.getAnnotations().containsKey("count")) {
            buf.append('[');
            buf.append(this.getAnnotations().get("count").toString());
            buf.append("] ");
        } else {
            buf.append(' ');
        }
        return buf;
    }

    public void accept(FilterVisitor a_visitor) {
        if (a_visitor.canVisit(this)) {
            a_visitor.visit(this);
        }
    }
}

