/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.codec.LdapResponse;
import org.apache.directory.shared.ldap.util.StringTools;

public class ExtendedResponse
extends LdapResponse {
    private OID responseName;
    private Object response;
    private transient int extendedResponseLength;
    private transient int responseNameLength;

    public int getMessageType() {
        return 10;
    }

    public String getResponseName() {
        return this.responseName == null ? "" : this.responseName.toString();
    }

    public void setResponseName(OID responseName) {
        this.responseName = responseName;
    }

    public Object getResponse() {
        return this.response;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public int computeLength() {
        this.extendedResponseLength = super.computeLength();
        if (this.responseName != null) {
            this.responseNameLength = this.responseName.toString().length();
            this.extendedResponseLength += 1 + TLV.getNbBytes((int)this.responseNameLength) + this.responseNameLength;
        }
        if (this.response != null) {
            if (this.response instanceof String) {
                int responseLength = StringTools.getBytesUtf8((String)this.response).length;
                this.extendedResponseLength += 1 + TLV.getNbBytes((int)responseLength) + responseLength;
            } else {
                this.extendedResponseLength += 1 + TLV.getNbBytes((int)((byte[])this.response).length) + ((byte[])this.response).length;
            }
        }
        return 1 + TLV.getNbBytes((int)this.extendedResponseLength) + this.extendedResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)120);
            buffer.put(TLV.getBytes((int)this.extendedResponseLength));
            super.encode(buffer);
            if (this.responseName != null) {
                buffer.put((byte)-118);
                buffer.put(TLV.getBytes((int)this.responseNameLength));
                if (this.responseName.getOIDLength() != 0) {
                    buffer.put(StringTools.getBytesUtf8(this.responseName.toString()));
                }
            }
            if (this.response != null) {
                buffer.put((byte)-117);
                if (this.response instanceof String) {
                    byte[] responseBytes = StringTools.getBytesUtf8((String)this.response);
                    buffer.put(TLV.getBytes((int)responseBytes.length));
                    if (responseBytes.length != 0) {
                        buffer.put(responseBytes);
                    }
                } else {
                    buffer.put(TLV.getBytes((int)((byte[])this.response).length));
                    if (((byte[])this.response).length != 0) {
                        buffer.put((byte[])this.response);
                    }
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Extended Response\n");
        sb.append(super.toString());
        if (this.responseName != null) {
            sb.append("        Response name :'").append(this.responseName).append("'\n");
        }
        if (this.response != null) {
            sb.append("        Response :'").append(this.response).append("'\n");
        }
        return sb.toString();
    }
}

