/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.OrFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitOrFilterAction
extends GrammarAction {
    private static final Logger log;
    private static final boolean IS_DEBUG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.codec.actions.InitOrFilterAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        IS_DEBUG = log.isDebugEnabled();
    }

    public InitOrFilterAction() {
        super("Initialize OR filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            log.error("The Or filter PDU must not be empty");
            throw new DecoderException("The Or filter PDU must not be empty");
        }
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        OrFilter orFilter = new OrFilter(ldapMessageContainer.getTlvId());
        searchRequest.addCurrentFilter(orFilter);
        if (IS_DEBUG) {
            log.debug("Initialize OR filter");
        }
    }
}

