/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitApproxMatchFilterAction
extends GrammarAction {
    private static final Logger log;
    private static final boolean IS_DEBUG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.ldap.codec.actions.InitApproxMatchFilterAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        IS_DEBUG = log.isDebugEnabled();
    }

    public InitApproxMatchFilterAction() {
        super("Init Approx Match filter Value");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(ldapMessageContainer.getTlvId(), 3);
        searchRequest.addCurrentFilter(filter);
        searchRequest.setTerminalFilter(filter);
        if (IS_DEBUG) {
            log.debug("Initialize Approx Match filter");
        }
    }
}

