/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.Control;
import org.apache.directory.shared.ldap.codec.LdapResponse;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequest;
import org.apache.directory.shared.ldap.codec.add.AddRequest;
import org.apache.directory.shared.ldap.codec.add.AddResponse;
import org.apache.directory.shared.ldap.codec.bind.BindRequest;
import org.apache.directory.shared.ldap.codec.bind.BindResponse;
import org.apache.directory.shared.ldap.codec.compare.CompareRequest;
import org.apache.directory.shared.ldap.codec.compare.CompareResponse;
import org.apache.directory.shared.ldap.codec.del.DelRequest;
import org.apache.directory.shared.ldap.codec.del.DelResponse;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequest;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponse;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequest;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponse;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequest;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponse;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.codec.search.SearchResultDone;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntry;
import org.apache.directory.shared.ldap.codec.search.SearchResultReference;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequest;

public class LdapMessage
extends Asn1Object {
    private int messageId;
    private Asn1Object protocolOp;
    private ArrayList controls;
    private transient Control currentControl;
    private transient int ldapMessageLength;
    private transient int controlsLength;
    private transient int controlsSequenceLength;

    public Control getControls(int i) {
        return (Control)((Object)this.controls.get(i));
    }

    public ArrayList getControls() {
        return this.controls;
    }

    public Control getCurrentControl() {
        return this.currentControl;
    }

    public void addControl(Control control) {
        this.currentControl = control;
        if (this.controls == null) {
            this.controls = new ArrayList();
        }
        this.controls.add(control);
    }

    public void initControls() {
        this.controls = new ArrayList();
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public int getMessageType() {
        return ((LdapMessage)this.protocolOp).getMessageType();
    }

    public String getMessageTypeName() {
        switch (((LdapMessage)this.protocolOp).getMessageType()) {
            case 0: {
                return "ABANDON_REQUEST";
            }
            case 1: {
                return "ADD_REQUEST";
            }
            case 2: {
                return "ADD_RESPONSE";
            }
            case 3: {
                return "BIND_REQUEST";
            }
            case 4: {
                return "BIND_RESPONSE";
            }
            case 5: {
                return "COMPARE_REQUEST";
            }
            case 6: {
                return "COMPARE_RESPONSE";
            }
            case 7: {
                return "DEL_REQUEST";
            }
            case 8: {
                return "DEL_RESPONSE";
            }
            case 9: {
                return "EXTENDED_REQUEST";
            }
            case 10: {
                return "EXTENDED_RESPONSE";
            }
            case 11: {
                return "MODIFYDN_REQUEST";
            }
            case 12: {
                return "MODIFYDN_RESPONSE";
            }
            case 13: {
                return "MODIFY_REQUEST";
            }
            case 14: {
                return "MODIFY_RESPONSE";
            }
            case 15: {
                return "SEARCH_REQUEST";
            }
            case 16: {
                return "SEARCH_RESULT_DONE";
            }
            case 17: {
                return "SEARCH_RESULT_ENTRY";
            }
            case 18: {
                return "SEARCH_RESULT_REFERENCE";
            }
            case 19: {
                return "UNBIND_REQUEST";
            }
        }
        return "UNKNOWN";
    }

    public LdapResponse getLdapResponse() {
        return (LdapResponse)this.protocolOp;
    }

    public AbandonRequest getAbandonRequest() {
        return (AbandonRequest)this.protocolOp;
    }

    public AddRequest getAddRequest() {
        return (AddRequest)this.protocolOp;
    }

    public AddResponse getAddResponse() {
        return (AddResponse)this.protocolOp;
    }

    public BindRequest getBindRequest() {
        return (BindRequest)this.protocolOp;
    }

    public BindResponse getBindResponse() {
        return (BindResponse)this.protocolOp;
    }

    public CompareRequest getCompareRequest() {
        return (CompareRequest)this.protocolOp;
    }

    public CompareResponse getCompareResponse() {
        return (CompareResponse)this.protocolOp;
    }

    public DelRequest getDelRequest() {
        return (DelRequest)this.protocolOp;
    }

    public DelResponse getDelResponse() {
        return (DelResponse)this.protocolOp;
    }

    public ExtendedRequest getExtendedRequest() {
        return (ExtendedRequest)this.protocolOp;
    }

    public ExtendedResponse getExtendedResponse() {
        return (ExtendedResponse)this.protocolOp;
    }

    public ModifyDNRequest getModifyDNRequest() {
        return (ModifyDNRequest)this.protocolOp;
    }

    public ModifyDNResponse getModifyDNResponse() {
        return (ModifyDNResponse)this.protocolOp;
    }

    public ModifyRequest getModifyRequest() {
        return (ModifyRequest)this.protocolOp;
    }

    public ModifyResponse getModifyResponse() {
        return (ModifyResponse)this.protocolOp;
    }

    public SearchRequest getSearchRequest() {
        return (SearchRequest)this.protocolOp;
    }

    public SearchResultDone getSearchResultDone() {
        return (SearchResultDone)this.protocolOp;
    }

    public SearchResultEntry getSearchResultEntry() {
        return (SearchResultEntry)this.protocolOp;
    }

    public SearchResultReference getSearchResultReference() {
        return (SearchResultReference)this.protocolOp;
    }

    public UnBindRequest getUnBindRequest() {
        return (UnBindRequest)this.protocolOp;
    }

    public void setProtocolOP(Asn1Object protocolOp) {
        this.protocolOp = protocolOp;
    }

    public int computeLength() {
        this.ldapMessageLength = 2 + Value.getNbBytes((int)this.messageId);
        int protocolOpLength = this.protocolOp.computeLength();
        this.ldapMessageLength += protocolOpLength;
        if (this.controls != null) {
            this.controlsSequenceLength = 0;
            Iterator controlIterator = this.controls.iterator();
            while (controlIterator.hasNext()) {
                this.controlsSequenceLength += ((Control)((Object)controlIterator.next())).computeLength();
            }
            this.controlsLength = this.controlsSequenceLength;
            this.ldapMessageLength += 1 + TLV.getNbBytes((int)this.controlsSequenceLength) + this.controlsSequenceLength;
        }
        return 1 + this.ldapMessageLength + TLV.getNbBytes((int)this.ldapMessageLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        try {
            bb.put((byte)48);
            bb.put(TLV.getBytes((int)this.ldapMessageLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)bb, (int)this.messageId);
        this.protocolOp.encode(bb);
        if (this.controls != null) {
            bb.put((byte)-96);
            bb.put(TLV.getBytes((int)this.controlsLength));
            Iterator controlIterator = this.controls.iterator();
            while (controlIterator.hasNext()) {
                ((Control)((Object)controlIterator.next())).encode(bb);
            }
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("LdapMessage\n");
        sb.append("    message Id : ").append(this.messageId).append('\n');
        sb.append(this.protocolOp);
        if (this.controls != null) {
            int i = 0;
            while (i < this.controls.size()) {
                sb.append((Object)((Control)((Object)this.controls.get(i))));
                ++i;
            }
        }
        return sb.toString();
    }
}

