/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.util.ByteBuffer;
import org.apache.directory.shared.ldap.util.Position;

public class StringTools {
    static String defaultCharset = null;
    private static final byte[] HEX_CHAR = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static final int UTF8_MULTI_BYTES_MASK = 128;
    private static final int UTF8_TWO_BYTES_MASK = 224;
    private static final int UTF8_TWO_BYTES = 192;
    private static final int UTF8_THREE_BYTES_MASK = 240;
    private static final int UTF8_THREE_BYTES = 224;
    private static final int UTF8_FOUR_BYTES_MASK = 248;
    private static final int UTF8_FOUR_BYTES = 240;
    private static final int UTF8_FIVE_BYTES_MASK = 252;
    private static final int UTF8_FIVE_BYTES = 248;
    private static final int UTF8_SIX_BYTES_MASK = 254;
    private static final int UTF8_SIX_BYTES = 252;
    public static final boolean[] ALPHA = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] CHAR = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    public static final boolean[] DIGIT = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] HEX = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    public static final byte[] HEX_VALUE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final char[] LOWER_CASE = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '-', '\u0000', '\u0000', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    private static final int CHAR_ONE_BYTE_MASK = -128;
    private static final int CHAR_TWO_BYTES_MASK = -2048;
    private static final int CHAR_THREE_BYTES_MASK = -65536;
    private static final int CHAR_FOUR_BYTES_MASK = -2097152;
    private static final int CHAR_FIVE_BYTES_MASK = -67108864;
    private static final int CHAR_SIX_BYTES_MASK = Integer.MIN_VALUE;
    public static final int NOT_EQUAL = -1;
    public static final String EMPTY = "";
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static final String trimConsecutiveToOne(String str, char ch) {
        if (null == str || str.length() == 0) {
            return EMPTY;
        }
        char[] buffer = str.toCharArray();
        char[] newbuf = new char[buffer.length];
        int pos = 0;
        boolean same = false;
        for (int i = 0; i < buffer.length; ++i) {
            char car = buffer[i];
            if (car == ch) {
                if (same) continue;
                same = true;
                newbuf[pos++] = car;
                continue;
            }
            same = false;
            newbuf[pos++] = car;
        }
        return new String(newbuf, 0, pos);
    }

    public static final String deepTrim(String string) {
        return StringTools.deepTrim(string, false);
    }

    public static final String deepTrimToLower(String string) {
        return StringTools.deepTrim(string, true);
    }

    public static final String deepTrim(String str, boolean toLowerCase) {
        if (null == str || str.length() == 0) {
            return EMPTY;
        }
        char[] buf = str.toCharArray();
        char[] newbuf = new char[buf.length];
        boolean wsSeen = false;
        boolean isStart = true;
        int pos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char ch = buf[i];
            if (toLowerCase && Character.isUpperCase(ch)) {
                ch = Character.toLowerCase(ch);
            }
            if (Character.isWhitespace(ch)) {
                if (wsSeen) continue;
                wsSeen = true;
                if (isStart) {
                    isStart = false;
                    continue;
                }
                newbuf[pos++] = ch;
                continue;
            }
            wsSeen = false;
            isStart = false;
            newbuf[pos++] = ch;
        }
        return pos == 0 ? EMPTY : new String(newbuf, 0, wsSeen ? pos - 1 : pos);
    }

    public static final String centerTrunc(String str, int head, int tail) {
        StringBuffer buf = null;
        if (str.length() <= head + tail + 7 + str.length() / 10) {
            return str;
        }
        buf = new StringBuffer();
        buf.append('[').append(str.length()).append("][");
        buf.append(str.substring(0, head)).append("...");
        buf.append(str.substring(str.length() - tail));
        buf.append(']');
        return buf.toString();
    }

    public static final String toHexString(byte[] res) {
        StringBuffer buf = new StringBuffer(res.length << 1);
        for (int ii = 0; ii < res.length; ++ii) {
            String digit = Integer.toHexString(0xFF & res[ii]);
            if (digit.length() == 1) {
                digit = '0' + digit;
            }
            buf.append(digit);
        }
        return buf.toString().toUpperCase();
    }

    public static final String toLowerCase(String value) {
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = LOWER_CASE[chars[i]];
        }
        return new String(chars);
    }

    public static final byte[] toByteArray(String hexString) {
        int arrLength = hexString.length() >> 1;
        byte[] buf = new byte[arrLength];
        for (int ii = 0; ii < arrLength; ++ii) {
            int index = ii << 1;
            String l_digit = hexString.substring(index, index + 2);
            buf[ii] = (byte)Integer.parseInt(l_digit, 16);
        }
        return buf;
    }

    public static final String formatHtml(String source, boolean replaceNl, boolean replaceTag, boolean replaceQuote) {
        StringBuffer buf = new StringBuffer();
        int len = source.length();
        block8: for (int ii = 0; ii < len; ++ii) {
            char ch = source.charAt(ii);
            switch (ch) {
                case '\"': {
                    if (replaceQuote) {
                        buf.append("&quot;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '<': {
                    if (replaceTag) {
                        buf.append("&lt;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '>': {
                    if (replaceTag) {
                        buf.append("&gt;");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '\n': {
                    if (replaceNl) {
                        if (replaceTag) {
                            buf.append("&lt;br&gt;");
                            continue block8;
                        }
                        buf.append("<br>");
                        continue block8;
                    }
                    buf.append(ch);
                    continue block8;
                }
                case '\r': {
                    continue block8;
                }
                case '&': {
                    buf.append("&amp;");
                    continue block8;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    public static final Pattern getRegex(String initialPattern, String[] anyPattern, String finalPattern) throws PatternSyntaxException {
        StringBuffer buf = new StringBuffer();
        if (initialPattern != null) {
            buf.append('^').append(initialPattern);
        }
        if (anyPattern != null) {
            for (int i = 0; i < anyPattern.length; ++i) {
                buf.append(".*").append(anyPattern[i]);
            }
        }
        if (finalPattern != null) {
            buf.append(".*").append(finalPattern);
        } else {
            buf.append(".*");
        }
        return Pattern.compile(buf.toString());
    }

    public static final Pattern getRegex(String ldapRegex) throws PatternSyntaxException {
        if (ldapRegex == null) {
            throw new PatternSyntaxException("Regex was null", "null", -1);
        }
        ArrayList<String> any = new ArrayList<String>();
        String remaining = ldapRegex;
        int index = remaining.indexOf(42);
        if (index == -1) {
            throw new PatternSyntaxException("Ldap regex must have wild cards!", remaining, -1);
        }
        String initialPattern = null;
        if (remaining.charAt(0) != '*') {
            initialPattern = remaining.substring(0, index);
        }
        remaining = remaining.substring(index + 1, remaining.length());
        while ((index = remaining.indexOf(42)) != -1) {
            any.add(remaining.substring(0, index));
            remaining = remaining.substring(index + 1, remaining.length());
        }
        String finalPattern = null;
        if (!remaining.endsWith("*") && remaining.length() > 0) {
            finalPattern = remaining;
        }
        if (any.size() > 0) {
            String[] anyStrs = new String[any.size()];
            for (int i = 0; i < anyStrs.length; ++i) {
                anyStrs[i] = (String)any.get(i);
            }
            return StringTools.getRegex(initialPattern, anyStrs, finalPattern);
        }
        return StringTools.getRegex(initialPattern, null, finalPattern);
    }

    public static final List getPaths(String paths, FileFilter filter) {
        int max = paths.length() - 1;
        int start = 0;
        int stop = -1;
        String path = null;
        ArrayList<String> list = new ArrayList<String>();
        if (paths == null || paths.trim().equals(EMPTY)) {
            return list;
        }
        while (start < max) {
            stop = paths.indexOf(File.pathSeparatorChar, start);
            if (stop == -1) {
                if (start >= max || (path = paths.substring(start)).trim().equals(EMPTY) || filter != null && !filter.accept(new File(path))) break;
                list.add(path);
                break;
            }
            path = paths.substring(start, stop);
            if (!path.trim().equals(EMPTY) && (filter == null || filter.accept(new File(path)))) {
                list.add(path);
            }
            start = stop + 1;
        }
        return list;
    }

    public static final String dumpByte(byte octet) {
        return new String(new byte[]{48, 120, HEX_CHAR[(octet & 0xF0) >> 4], HEX_CHAR[octet & 0xF]});
    }

    public static final char dumpHex(byte hex) {
        return (char)HEX_CHAR[hex & 0xF];
    }

    public static final String dumpBytes(byte[] buffer) {
        if (buffer == null) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            sb.append("0x").append((char)HEX_CHAR[(buffer[i] & 0xF0) >> 4]).append((char)HEX_CHAR[buffer[i] & 0xF]).append(" ");
        }
        return sb.toString();
    }

    public static final String dumpHexPairs(byte[] buffer) {
        if (buffer == null) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buffer.length; ++i) {
            sb.append((char)HEX_CHAR[(buffer[i] & 0xF0) >> 4]).append((char)HEX_CHAR[buffer[i] & 0xF]);
        }
        return sb.toString();
    }

    public static final char bytesToChar(byte[] bytes) {
        return StringTools.bytesToChar(bytes, 0);
    }

    public static final int countBytesPerChar(byte[] bytes, int pos) {
        if (bytes == null) {
            return -1;
        }
        if ((bytes[pos] & 0x80) == 0) {
            return 1;
        }
        if ((bytes[pos] & 0xE0) == 192) {
            return 2;
        }
        if ((bytes[pos] & 0xF0) == 224) {
            return 3;
        }
        if ((bytes[pos] & 0xF8) == 240) {
            return 4;
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return 5;
        }
        if ((bytes[pos] & 0xFE) == 252) {
            return 6;
        }
        return -1;
    }

    public static final int countNbBytesPerChar(char car) {
        if ((car & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((car & 0xFFFFF800) == 0) {
            return 2;
        }
        if ((car & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((car & 0xFFE00000) == 0) {
            return 4;
        }
        if ((car & 0xFC000000) == 0) {
            return 5;
        }
        if ((car & Integer.MIN_VALUE) == 0) {
            return 6;
        }
        return -1;
    }

    public static final int countBytes(char[] chars) {
        if (chars == null) {
            return 0;
        }
        int nbBytes = 0;
        int currentPos = 0;
        while (currentPos < chars.length) {
            int nbb;
            currentPos += (nbb = StringTools.countNbBytesPerChar(chars[currentPos])) < 4 ? 1 : 2;
            nbBytes += nbb;
        }
        return nbBytes;
    }

    public static final char bytesToChar(byte[] bytes, int pos) {
        if (bytes == null) {
            return '\uffff';
        }
        if ((bytes[pos] & 0x80) == 0) {
            return (char)bytes[pos];
        }
        if ((bytes[pos] & 0xE0) == 192) {
            return (char)(((bytes[pos] & 0x1C) << 6) + ((bytes[pos] & 3) << 6) + (bytes[pos + 1] & 0x3F));
        }
        if ((bytes[pos] & 0xF0) == 224) {
            return (char)(((bytes[pos] & 0xF) << 12) + ((bytes[pos + 1] & 0x3C) << 6) + ((bytes[pos + 1] & 3) << 6) + (bytes[pos + 2] & 0x3F));
        }
        if ((bytes[pos] & 0xF8) == 240) {
            return (char)(((bytes[pos] & 7) << 18) + ((bytes[pos + 1] & 0x30) << 16) + ((bytes[pos + 1] & 0xF) << 12) + ((bytes[pos + 2] & 0x3C) << 6) + ((bytes[pos + 2] & 3) << 6) + (bytes[pos + 3] & 0x3F));
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return (char)(((bytes[pos] & 3) << 24) + ((bytes[pos + 1] & 0x3F) << 18) + ((bytes[pos + 2] & 0x30) << 12) + ((bytes[pos + 2] & 0xF) << 12) + ((bytes[pos + 3] & 0x3C) << 6) + ((bytes[pos + 3] & 3) << 6) + (bytes[pos + 4] & 0x3F));
        }
        if ((bytes[pos] & 0xFC) == 248) {
            return (char)(((bytes[pos] & 1) << 30) + ((bytes[pos + 1] & 0x3F) << 24) + ((bytes[pos + 2] & 0x3F) << 18) + ((bytes[pos + 3] & 0x30) << 12) + ((bytes[pos + 3] & 0xF) << 12) + ((bytes[pos + 4] & 0x3C) << 6) + ((bytes[pos + 4] & 3) << 6) + (bytes[pos + 5] & 0x3F));
        }
        return '\uffff';
    }

    public static final byte[] charToBytes(char car) {
        byte[] bytes = new byte[StringTools.countNbBytesPerChar(car)];
        if (car <= '\u007f') {
            bytes[0] = (byte)car;
            return bytes;
        }
        if (car <= '\u07ff') {
            bytes[0] = (byte)(192 + ((car & 0x7C0) >> 6));
            bytes[1] = (byte)(128 + (car & 0x3F));
        } else {
            bytes[0] = (byte)(224 + ((car & 0xF000) >> 12));
            bytes[1] = (byte)(128 + ((car & 0xFC0) >> 6));
            bytes[2] = (byte)(128 + (car & 0x3F));
        }
        return bytes;
    }

    public static final int countChars(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int nbChars = 0;
        int currentPos = 0;
        while (currentPos < bytes.length) {
            currentPos += StringTools.countBytesPerChar(bytes, currentPos);
            ++nbChars;
        }
        return nbChars;
    }

    public static final int areEquals(byte[] byteArray, int index, String text) {
        if (byteArray == null || byteArray.length == 0 || byteArray.length <= index || index < 0 || text == null) {
            return -1;
        }
        try {
            byte[] data = text.getBytes("UTF-8");
            return StringTools.areEquals(byteArray, index, data);
        }
        catch (UnsupportedEncodingException uee) {
            return -1;
        }
    }

    public static final int areEquals(char[] charArray, int index, String text) {
        if (charArray == null || charArray.length == 0 || charArray.length <= index || index < 0 || text == null) {
            return -1;
        }
        char[] data = text.toCharArray();
        return StringTools.areEquals(charArray, index, data);
    }

    public static final int areEquals(char[] charArray, int index, char[] charArray2) {
        if (charArray == null || charArray.length == 0 || charArray.length <= index || index < 0 || charArray2 == null || charArray2.length == 0 || charArray2.length > charArray.length + index) {
            return -1;
        }
        for (int i = 0; i < charArray2.length; ++i) {
            if (charArray[index++] == charArray2[i]) continue;
            return -1;
        }
        return index;
    }

    public static final boolean areEquals(String string1, int index, String text) {
        int length1 = string1.length();
        int length2 = text.length();
        if (string1 == null || length1 == 0 || length1 <= index || index < 0 || text == null || length2 == 0 || length2 > length1 + index) {
            return false;
        }
        return string1.substring(index).startsWith(text);
    }

    public static final int areEquals(byte[] byteArray, int index, byte[] byteArray2) {
        if (byteArray == null || byteArray.length == 0 || byteArray.length <= index || index < 0 || byteArray2 == null || byteArray2.length == 0 || byteArray2.length > byteArray.length + index) {
            return -1;
        }
        for (int i = 0; i < byteArray2.length; ++i) {
            if (byteArray[index++] == byteArray2[i]) continue;
            return -1;
        }
        return index;
    }

    public static final boolean isCharASCII(byte[] byteArray, int index, char car) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return byteArray[index] == car;
    }

    public static final boolean isCharASCII(char[] chars, int index, char car) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] == car;
    }

    public static final boolean isCharASCII(String string, int index, char car) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        return string.charAt(index) == car;
    }

    public static final char charAt(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return '\u0000';
        }
        return string.charAt(index);
    }

    public static final boolean isHex(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        byte c = byteArray[index];
        return c <= 127 && HEX[c];
    }

    public static final boolean isHex(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        char c = chars[index];
        return c <= '\u007f' && HEX[c];
    }

    public static final boolean isHex(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && HEX[c];
    }

    public static final boolean isDigit(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return false;
        }
        return byteArray[0] <= 127 && DIGIT[byteArray[0]];
    }

    public static final boolean isDigit(char car) {
        return car >= '0' && car <= '9';
    }

    public static final boolean isAlphaASCII(byte[] byteArray, int index) {
        byte c;
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return (c = byteArray[index++]) <= 127 && ALPHA[c];
    }

    public static final boolean isAlphaASCII(char[] chars, int index) {
        char c;
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return (c = chars[index++]) <= '\u007f' && ALPHA[c];
    }

    public static final boolean isAlphaASCII(String string, int index) {
        char c;
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        return (c = string.charAt(index++)) <= '\u007f' && ALPHA[c];
    }

    public static final boolean isDigit(byte[] byteArray, int index) {
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return byteArray[index] <= 127 && DIGIT[byteArray[index]];
    }

    public static final boolean isDigit(char[] chars, int index) {
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return chars[index] <= '\u007f' && DIGIT[chars[index]];
    }

    public static final boolean isDigit(String string, int index) {
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        char c = string.charAt(index);
        return c <= '\u007f' && DIGIT[c];
    }

    public static final boolean isDigit(char[] chars) {
        if (chars == null || chars.length == 0) {
            return false;
        }
        return chars[0] <= '\u007f' && DIGIT[chars[0]];
    }

    public static final boolean isAlphaDigitMinus(byte[] byteArray, int index) {
        byte c;
        if (byteArray == null || byteArray.length == 0 || index < 0 || index >= byteArray.length) {
            return false;
        }
        return (c = byteArray[index++]) <= 127 && CHAR[c];
    }

    public static final boolean isAlphaDigitMinus(char[] chars, int index) {
        char c;
        if (chars == null || chars.length == 0 || index < 0 || index >= chars.length) {
            return false;
        }
        return (c = chars[index++]) <= '\u007f' && CHAR[c];
    }

    public static final boolean isAlphaDigitMinus(String string, int index) {
        char c;
        int length = string.length();
        if (string == null || length == 0 || index < 0 || index >= length) {
            return false;
        }
        return (c = string.charAt(index++)) <= '\u007f' && CHAR[c];
    }

    public static final boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean isEmpty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static final boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static final String trim(String str) {
        return StringTools.isEmpty(str) ? EMPTY : str.trim();
    }

    public static final byte[] trim(byte[] bytes) {
        if (StringTools.isEmpty(bytes)) {
            return EMPTY_BYTES;
        }
        int start = StringTools.trimLeft(bytes, 0);
        int end = StringTools.trimRight(bytes, bytes.length - 1);
        int length = end - start + 1;
        if (length != 0) {
            byte[] newBytes = new byte[end - start + 1];
            System.arraycopy(bytes, start, newBytes, 0, length);
            return newBytes;
        }
        return EMPTY_BYTES;
    }

    public static final String trimLeft(String str) {
        int start;
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        int end = str.length();
        for (start = 0; start < end && str.charAt(start) == ' '; ++start) {
        }
        return start == 0 ? str : str.substring(start);
    }

    public static final int trimLeft(char[] chars, int pos) {
        if (chars == null) {
            return pos;
        }
        while (pos < chars.length && chars[pos] == ' ') {
            ++pos;
        }
        return pos;
    }

    public static final void trimLeft(String string, Position pos) {
        if (string == null) {
            return;
        }
        int length = string.length();
        while (pos.start < length && string.charAt(pos.start) == ' ') {
            ++pos.start;
        }
        pos.end = pos.start;
    }

    public static final int trimLeft(byte[] bytes, int pos) {
        if (bytes == null) {
            return pos;
        }
        while (pos < bytes.length && bytes[pos] == 32) {
            ++pos;
        }
        return pos;
    }

    public static final String trimRight(String str) {
        int length;
        int end;
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        for (end = length = str.length(); end > 0 && str.charAt(end - 1) == ' ' && (end <= 1 || str.charAt(end - 2) != '\\'); --end) {
        }
        return end == length ? str : str.substring(0, end);
    }

    public static final String trimRight(String str, int escapedSpace) {
        int length;
        int end;
        if (StringTools.isEmpty(str)) {
            return EMPTY;
        }
        for (end = length = str.length(); end > 0 && str.charAt(end - 1) == ' ' && end > escapedSpace && (end <= 1 || str.charAt(end - 2) != '\\'); --end) {
        }
        return end == length ? str : str.substring(0, end);
    }

    public static final int trimRight(char[] chars, int pos) {
        if (chars == null) {
            return pos;
        }
        while (pos >= 0 && chars[pos - 1] == ' ') {
            --pos;
        }
        return pos;
    }

    public static final String trimRight(String string, Position pos) {
        if (string == null) {
            return EMPTY;
        }
        while (pos.end >= 0 && string.charAt(pos.end - 1) == ' ' && (pos.end <= 1 || string.charAt(pos.end - 2) != '\\')) {
            --pos.end;
        }
        return pos.end == string.length() ? string : string.substring(0, pos.end);
    }

    public static final int trimRight(byte[] bytes, int pos) {
        if (bytes == null) {
            return pos;
        }
        while (pos >= 0 && bytes[pos] == 32) {
            --pos;
        }
        return pos;
    }

    public static final String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static final String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static final boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static final String utf8ToString(byte[] bytes) {
        if (bytes == null) {
            return EMPTY;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return EMPTY;
        }
    }

    public static final String utf8ToString(byte[] bytes, int length) {
        if (bytes == null) {
            return EMPTY;
        }
        try {
            return new String(bytes, 0, length, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return EMPTY;
        }
    }

    public static final byte[] getBytesUtf8(String string) {
        if (string == null) {
            return new byte[0];
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return new byte[0];
        }
    }

    public static final String listToString(List list) {
        if (list == null || list.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public static final String listToString(List list, String tabs) {
        if (list == null || list.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            sb.append(tabs);
            sb.append(iter.next());
            sb.append('\n');
        }
        return sb.toString();
    }

    public static final String mapToString(Map map) {
        if (map == null || map.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            Object key = iter.next();
            sb.append(key);
            sb.append(" = '").append(map.get(key)).append("'");
        }
        return sb.toString();
    }

    public static final String mapToString(Map map, String tabs) {
        if (map == null || map.size() == 0) {
            return EMPTY;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            sb.append(tabs);
            sb.append(key);
            Object value = map.get(key);
            sb.append(" = '").append(value.toString()).append("'\n");
        }
        return sb.toString();
    }

    public static final String getDefaultCharsetName() {
        if (null == defaultCharset) {
            try {
                Method method = Charset.class.getMethod("defaultCharset", new Class[0]);
                defaultCharset = ((Charset)method.invoke(null, new Object[0])).name();
            }
            catch (Exception e) {
                defaultCharset = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            }
        }
        return defaultCharset;
    }

    public static final String decodeHexString(String str) throws InvalidNameException {
        if (str == null || str.length() == 0) {
            throw new InvalidNameException("Expected string to start with a '#' character.  Invalid hex encoded string for empty or null string.");
        }
        char[] chars = str.toCharArray();
        if (chars[0] != '#') {
            throw new InvalidNameException("Expected string to start with a '#' character.  Invalid hex encoded string: " + str);
        }
        byte[] decoded = new byte[chars.length - 1 >> 1];
        int ii = 1;
        int jj = 0;
        while (ii < chars.length) {
            int ch = (HEX_VALUE[chars[ii]] << 4) + HEX_VALUE[chars[ii + 1]];
            decoded[jj] = (byte)ch;
            ii += 2;
            ++jj;
        }
        return StringTools.utf8ToString(decoded);
    }

    public static final String decodeEscapedHex(String str) throws InvalidNameException {
        int length = str.length();
        if (str == null || length == 0) {
            throw new InvalidNameException("Expected string to be non-empty or non-null with valid index.");
        }
        StringBuffer buf = new StringBuffer();
        ByteBuffer bb = new ByteBuffer();
        for (int ii = 0; ii < length; ++ii) {
            if (str.charAt(ii) == '\\') {
                if (StringTools.isHex(str, ii + 1) && StringTools.isHex(str, ii + 2)) {
                    bb.clear();
                    int advancedBy = StringTools.collectEscapedHexBytes(bb, str, ii);
                    ii += advancedBy - 1;
                    buf.append(StringTools.utf8ToString(bb.buffer(), bb.position()));
                    continue;
                }
                buf.append(str.charAt(ii));
                continue;
            }
            buf.append(str.charAt(ii));
        }
        return buf.toString();
    }

    private static int collectEscapedHexBytes(ByteBuffer bb, String str, int index) {
        int advanceBy = 0;
        int ii = index;
        while (ii < str.length() && StringTools.isHex(str, ii + 1) && StringTools.isHex(str, ii + 2)) {
            int bite = (HEX_VALUE[str.charAt(ii + 1)] << 4) + HEX_VALUE[str.charAt(ii + 2)];
            bb.append(bite);
            ii += 3;
            advanceBy += 3;
        }
        return advanceBy;
    }

    public static String asciiBytesToString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return EMPTY;
        }
        char[] result = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = (char)bytes[i];
        }
        return new String(result);
    }
}

