/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import java.util.Collections;
import java.util.Set;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;

public class BaseSubtreeSpecification
implements SubtreeSpecification {
    private final LdapDN base;
    private final Set chopBefore;
    private final Set chopAfter;
    private final int minBaseDistance;
    private final int maxBaseDistance;
    private final ExprNode refinement;

    public BaseSubtreeSpecification() {
        this.base = new LdapDN();
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = null;
    }

    public BaseSubtreeSpecification(ExprNode refinement) {
        this.base = new LdapDN();
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = refinement;
    }

    public BaseSubtreeSpecification(LdapDN base) {
        this.base = base;
        this.minBaseDistance = 0;
        this.maxBaseDistance = -1;
        this.chopAfter = Collections.EMPTY_SET;
        this.chopBefore = Collections.EMPTY_SET;
        this.refinement = null;
    }

    public BaseSubtreeSpecification(LdapDN base, int minBaseDistance, int maxBaseDistance, Set chopAfter, Set chopBefore) {
        this(base, minBaseDistance, maxBaseDistance, chopAfter, chopBefore, null);
    }

    public BaseSubtreeSpecification(LdapDN base, int minBaseDistance, int maxBaseDistance, Set chopAfter, Set chopBefore, ExprNode refinement) {
        this.base = base;
        this.minBaseDistance = minBaseDistance;
        this.maxBaseDistance = maxBaseDistance < 0 ? -1 : maxBaseDistance;
        this.chopAfter = chopAfter;
        this.chopBefore = chopBefore;
        this.refinement = refinement;
    }

    public LdapDN getBase() {
        return this.base;
    }

    public Set getChopBeforeExclusions() {
        return this.chopBefore;
    }

    public Set getChopAfterExclusions() {
        return this.chopAfter;
    }

    public int getMinBaseDistance() {
        return this.minBaseDistance;
    }

    public int getMaxBaseDistance() {
        return this.maxBaseDistance;
    }

    public ExprNode getRefinement() {
        return this.refinement;
    }
}

