/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.extended;

import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulShutdown;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulShutdownDecoder;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.ResultResponse;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownRequest
extends ExtendedRequestImpl {
    private static final Logger log = LoggerFactory.getLogger((Class)GracefulShutdownRequest.class);
    private static final long serialVersionUID = -4682291068700593492L;
    public static final String EXTENSION_OID = "1.2.6.1.4.1.18060.1.1.1.100.3";
    public static final int UNDETERMINED = 0;
    public static final int NOW = 0;
    private int timeOffline;
    private int delay;

    public GracefulShutdownRequest(int messageId) {
        this(messageId, 0, 0);
    }

    public GracefulShutdownRequest(int messageId, int timeOffline, int delay) {
        super(messageId);
        this.setOid(EXTENSION_OID);
        this.timeOffline = timeOffline;
        this.delay = delay;
    }

    private void encodePayload() throws EncoderException {
        GracefulShutdown gs = new GracefulShutdown();
        gs.setDelay(this.delay);
        gs.setTimeOffline(this.timeOffline);
        this.payload = gs.encode(null).array();
    }

    public void setPayload(byte[] payload) {
        GracefulShutdownDecoder decoder = new GracefulShutdownDecoder();
        try {
            GracefulShutdown gs = (GracefulShutdown)decoder.decode(payload);
            this.payload = payload;
            this.timeOffline = gs.getTimeOffline();
            this.delay = gs.getDelay();
        }
        catch (DecoderException e) {
            log.error("failed to decode payload", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (NamingException e) {
            log.error("failed to decode payload", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return (ExtendedResponse)((Object)this.getResultResponse());
    }

    public byte[] getEncodedValue() {
        return this.getPayload();
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            try {
                this.encodePayload();
            }
            catch (EncoderException e) {
                log.error("Failed to encode payload GracefulShutdownRequest", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.payload;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            GracefulShutdownResponse gsr = new GracefulShutdownResponse(this.getMessageId());
            this.response = gsr;
        }
        return this.response;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getTimeOffline() {
        return this.timeOffline;
    }

    public void setTimeOffline(int timeOffline) {
        this.timeOffline = timeOffline;
    }
}

