/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstringFilterGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)SubstringFilterGrammar.class);
    private static IGrammar instance = new SubstringFilterGrammar();

    private SubstringFilterGrammar() {
        this.name = SubstringFilterGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_SUBSTRING_FILTER_STATE][256];
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_TAG][164] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_TAG, LdapStatesEnum.SUBSTRINGS_FILTER_VALUE, null);
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_VALUE][164] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_VALUE, LdapStatesEnum.SUBSTRINGS_FILTER_TYPE_TAG, new GrammarAction("Init Substring Filter"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The Substring filter PDU must not be empty");
                    throw new DecoderException("The Substring filter PDU must not be empty");
                }
                SubstringFilter substringFilter = new SubstringFilter();
                searchRequest.addCurrentFilter(substringFilter);
                searchRequest.setTerminalFilter(substringFilter);
                int expectedLength = tlv.getLength().getLength();
                substringFilter.setExpectedLength(expectedLength);
                substringFilter.setCurrentLength(0);
            }
        });
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_TYPE_TAG, LdapStatesEnum.SUBSTRINGS_FILTER_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_TYPE_VALUE, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_SEQ_TAG, new GrammarAction("Store substring filter Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The attribute description should not be null");
                    throw new DecoderException("The attribute description should not be null");
                }
                try {
                    LdapString type = new LdapString(tlv.getValue().getData());
                    substringFilter.setType(type);
                }
                catch (LdapStringEncodingException lsee) {
                    String msg = StringTools.dumpBytes(tlv.getValue().getData());
                    log.error("The substring filter type ({}) is invalid", (Object)msg);
                    throw new DecoderException("Invalid substring filter type " + msg + ", : " + lsee.getMessage());
                }
                searchRequest.setTerminalFilter(substringFilter);
            }
        });
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_SEQ_TAG][48] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_SEQ_TAG, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_SEQ_VALUE, null);
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_SEQ_VALUE][48] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_SEQ_VALUE, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_OR_ANY_OR_FINAL_TAG, new GrammarAction("Substring Filter substringsSequence "){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The substrings sequence is empty");
                    throw new DecoderException("The substring sequence is empty");
                }
            }
        });
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_OR_ANY_OR_FINAL_TAG][128] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_OR_ANY_OR_FINAL_TAG, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_VALUE, null);
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_VALUE][128] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_VALUE, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_OR_FINAL_TAG, new GrammarAction("Store substring filter initial Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The substring initial filter is empty");
                    throw new DecoderException("The substring initial filter is empty");
                }
                try {
                    substringFilter.setInitialSubstrings(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    String msg = StringTools.dumpBytes(tlv.getValue().getData());
                    log.error("The substring filter initial ({}) is invalid");
                    throw new DecoderException("Invalid substring filter initial " + msg + ", : " + lsee.getMessage());
                }
                searchRequest.unstackFilters(container);
                container.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_OR_ANY_OR_FINAL_TAG][129] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_OR_ANY_OR_FINAL_TAG, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_VALUE, null);
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_OR_FINAL_TAG][129] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_OR_FINAL_TAG, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_VALUE, null);
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_VALUE][129] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_VALUE, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_OR_FINAL_TAG, new GrammarAction("Store substring filter any Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The substring any filter is empty");
                    throw new DecoderException("The substring any filter is empty");
                }
                try {
                    substringFilter.addAnySubstrings(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    String msg = StringTools.dumpBytes(tlv.getValue().getData());
                    log.error("The substring any filter ({}) is invalid", (Object)msg);
                    throw new DecoderException("Invalid substring any filter " + msg + ", : " + lsee.getMessage());
                }
                searchRequest.unstackFilters(container);
                container.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_OR_FINAL_TAG][130] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_ANY_OR_FINAL_TAG, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_FINAL_VALUE, null);
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_OR_ANY_OR_FINAL_TAG][130] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_INITIAL_OR_ANY_OR_FINAL_TAG, LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_FINAL_VALUE, null);
        this.transitions[LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_FINAL_VALUE][130] = new GrammarTransition(LdapStatesEnum.SUBSTRINGS_FILTER_SUBSTRINGS_FINAL_VALUE, -1, new GrammarAction("Store substring filter final Value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The substring final filter is empty");
                    throw new DecoderException("The substring final filter is empty");
                }
                try {
                    substringFilter.setFinalSubstrings(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    String msg = StringTools.dumpBytes(tlv.getValue().getData());
                    log.error("The substring final filter ({}) is invalid", (Object)msg);
                    throw new DecoderException("Invalid substring final filter " + msg + ", : " + lsee.getMessage());
                }
                searchRequest.unstackFilters(container);
                container.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

