/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.SearchResponseDoneImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)SearchRequestGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new SearchRequestGrammar();

    private SearchRequestGrammar() {
        this.name = SearchRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_SEARCH_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TAG][99] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TAG, LdapStatesEnum.SEARCH_REQUEST_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_VALUE][99] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_VALUE, LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_TAG, new GrammarAction("Init SearchRequest"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.setProtocolOP(new SearchRequest());
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_TAG, LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_BASE_OBJECT_VALUE, LdapStatesEnum.SEARCH_REQUEST_SCOPE_TAG, new GrammarAction("store base object value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                SearchRequest searchRequest = ldapMessage.getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapDN baseObject = LdapDN.EMPTY_LDAPDN;
                if (tlv.getLength().getLength() != 0) {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        baseObject = new LdapDN(dnBytes);
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Invalid root DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        SearchResponseDoneImpl response = new SearchResponseDoneImpl(ldapMessage.getMessageId());
                        throw new ResponseCarryingException(msg, response, ResultCodeEnum.INVALIDDNSYNTAX, LdapDN.EMPTY_LDAPDN, ine);
                    }
                }
                searchRequest.setBaseObject(baseObject);
                log.debug("Searching with root DN : {}", (Object)baseObject);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_SCOPE_TAG][10] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_SCOPE_TAG, LdapStatesEnum.SEARCH_REQUEST_SCOPE_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_SCOPE_VALUE][10] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_SCOPE_VALUE, LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_TAG, new GrammarAction("store scope value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int scope = 0;
                try {
                    scope = IntegerDecoder.parse((Value)value, (int)0, (int)2);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The scope is not in [0..2] : {}", (Object)value.toString());
                    throw new DecoderException("The scope is not in [0..2] : " + value.toString());
                }
                searchRequest.setScope(scope);
                if (IS_DEBUG) {
                    switch (scope) {
                        case 0: {
                            log.debug("Searching within BASE_OBJECT scope ");
                            break;
                        }
                        case 1: {
                            log.debug("Searching within SINGLE_LEVEL scope ");
                            break;
                        }
                        case 2: {
                            log.debug("Searching within WHOLE_SUBTREE scope ");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_TAG][10] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_TAG, LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_VALUE][10] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_DEREF_ALIASES_VALUE, LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_TAG, new GrammarAction("store derefAliases value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int derefAliases = 0;
                try {
                    derefAliases = IntegerDecoder.parse((Value)value, (int)0, (int)3);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The derefAlias is not in [0..3] : {}", (Object)value.toString());
                    throw new DecoderException("The derefAlias is not in [0..3] : " + value.toString());
                }
                searchRequest.setDerefAliases(derefAliases);
                if (IS_DEBUG) {
                    switch (derefAliases) {
                        case 0: {
                            log.debug("Handling object strategy : NEVER_DEREF_ALIASES");
                            break;
                        }
                        case 1: {
                            log.debug("Handling object strategy : DEREF_IN_SEARCHING");
                            break;
                        }
                        case 2: {
                            log.debug("Handling object strategy : DEREF_FINDING_BASE_OBJ");
                            break;
                        }
                        case 3: {
                            log.debug("Handling object strategy : DEREF_ALWAYS");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_TAG][2] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_TAG, LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_VALUE][2] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_SIZE_LIMIT_VALUE, LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_TAG, new GrammarAction("store sizeLimit value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int sizeLimit = 0;
                try {
                    sizeLimit = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The sizeLimit is not a valid Integer: {}", (Object)value.toString());
                    throw new DecoderException("The sizeLimit is not a valid Integer: " + value.toString());
                }
                searchRequest.setSizeLimit(sizeLimit);
                if (IS_DEBUG) {
                    log.debug("The sizeLimit value is set to {} objects", (Object)new Integer(sizeLimit));
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_TAG][2] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_TAG, LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_VALUE][2] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TIME_LIMIT_VALUE, LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_TAG, new GrammarAction("store timeLimit value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                int timeLimit = 0;
                try {
                    timeLimit = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                }
                catch (IntegerDecoderException ide) {
                    log.error("The timeLimit is not a valid Integer: {}", (Object)value.toString());
                    throw new DecoderException("The timeLimit is not a valid Integer: " + value.toString());
                }
                searchRequest.setTimeLimit(timeLimit);
                if (IS_DEBUG) {
                    log.debug("The timeLimit value is set to {} seconds", (Object)new Integer(timeLimit));
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_TAG][1] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_TAG, LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_VALUE][1] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_TYPES_ONLY_VALUE, LdapStatesEnum.SEARCH_REQUEST_FILTER, new GrammarAction("store typesOnly value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    searchRequest.setTypesOnly(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The types only flag {} is invalid : {}. It should be 0 or 255", (Object)StringTools.dumpBytes(value.getData()), (Object)bde.getMessage());
                    throw new DecoderException(bde.getMessage());
                }
                if (IS_DEBUG) {
                    log.debug("The search will return {}", (Object)(searchRequest.isTypesOnly() ? "only attributs type" : "attributes types and values"));
                }
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][160] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][161] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][162] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][163] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][164] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][165] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][166] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][135] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][168] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][169] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, 3840, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_FILTER][48] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_FILTER, LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_LIST_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_LIST_VALUE][48] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_LIST_VALUE, LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_TAG, new GrammarAction("store Attribute Description List value"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_TAG][4] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_TAG, LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_VALUE, null);
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_VALUE][4] = new GrammarTransition(LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_VALUE, LdapStatesEnum.SEARCH_REQUEST_ATTRIBUTE_DESCRIPTION_TAG, new GrammarAction("store Attribute Description value"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                SearchRequest searchRequest = ldapMessageContainer.getLdapMessage().getSearchRequest();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                LdapString attributeDescription = null;
                byte[] value = null;
                value = tlv.getLength().getLength() == 0 ? new byte[]{42} : tlv.getValue().getData();
                try {
                    attributeDescription = new LdapString(value);
                    searchRequest.addAttribute(attributeDescription);
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("Cannot decode the attribute description : {}", (Object)StringTools.dumpBytes(tlv.getValue().getData()));
                    throw new DecoderException("Cannot decode the attribute description");
                }
                ldapMessageContainer.grammarEndAllowed(true);
                ldapMessageContainer.grammarPopAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Decoded Attribute Description : {}", (Object)attributeDescription.getString());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

