/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulShutdown;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulShutdownContainer;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulShutdownStatesEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulShutdownGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)GracefulShutdownGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new GracefulShutdownGrammar();

    private GracefulShutdownGrammar() {
        this.name = GracefulShutdownGrammar.class.getName();
        this.statesEnum = GracefulShutdownStatesEnum.getInstance();
        this.transitions = new GrammarTransition[GracefulShutdownStatesEnum.LAST_GRACEFUL_SHUTDOWN_STATE][256];
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_TAG][48] = new GrammarTransition(GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_TAG, GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_VALUE, null);
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_VALUE][48] = new GrammarTransition(GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_VALUE, GracefulShutdownStatesEnum.TIME_OFFLINE_OR_DELAY_OR_END_TAG, new GrammarAction("Init GracefulShutdown"){

            public void action(IAsn1Container container) {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                GracefulShutdown gracefulShutdown = new GracefulShutdown();
                gracefulShutdownContainer.setGracefulShutdown(gracefulShutdown);
                gracefulShutdownContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[GracefulShutdownStatesEnum.TIME_OFFLINE_OR_DELAY_OR_END_TAG][2] = new GrammarTransition(GracefulShutdownStatesEnum.TIME_OFFLINE_OR_DELAY_OR_END_TAG, GracefulShutdownStatesEnum.TIME_OFFLINE_VALUE, null);
        this.transitions[GracefulShutdownStatesEnum.TIME_OFFLINE_OR_DELAY_OR_END_TAG][128] = new GrammarTransition(GracefulShutdownStatesEnum.TIME_OFFLINE_OR_DELAY_OR_END_TAG, GracefulShutdownStatesEnum.DELAY_VALUE, null);
        this.transitions[GracefulShutdownStatesEnum.TIME_OFFLINE_VALUE][2] = new GrammarTransition(GracefulShutdownStatesEnum.TIME_OFFLINE_VALUE, GracefulShutdownStatesEnum.DELAY_OR_END_TAG, new GrammarAction("Set Graceful Shutdown time offline"){

            public void action(IAsn1Container container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int timeOffline = IntegerDecoder.parse((Value)value, (int)0, (int)720);
                    if (IS_DEBUG) {
                        log.debug("Time Offline = " + timeOffline);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setTimeOffline(timeOffline);
                    gracefulShutdownContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the timeOffline, the value should be between 0 and 720 minutes, it is '" + StringTools.dumpBytes(value.getData()) + "'";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.DELAY_OR_END_TAG][128] = new GrammarTransition(GracefulShutdownStatesEnum.DELAY_OR_END_TAG, GracefulShutdownStatesEnum.DELAY_VALUE, null);
        this.transitions[GracefulShutdownStatesEnum.DELAY_VALUE][128] = new GrammarTransition(GracefulShutdownStatesEnum.DELAY_VALUE, -1, new GrammarAction("Set Graceful Shutdown Delay"){

            public void action(IAsn1Container container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse((Value)value, (int)0, (int)86400);
                    if (IS_DEBUG) {
                        log.debug("Delay = " + delay);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setDelay(delay);
                    gracefulShutdownContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the delay, the value should be between 0 and 86400 seconds, it is '" + StringTools.dumpBytes(value.getData()) + "'";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

