/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapURL;
import org.apache.directory.shared.ldap.name.LdapDN;

public class LdapResult
extends Asn1Object {
    private int resultCode;
    private LdapDN matchedDN;
    private LdapString errorMessage;
    private ArrayList referrals = new ArrayList();
    private transient int referralsLength;

    public String getErrorMessage() {
        return this.errorMessage == null ? null : this.errorMessage.getString();
    }

    public void setErrorMessage(LdapString errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getMatchedDN() {
        return this.matchedDN == null ? "" : this.matchedDN.toString();
    }

    public void setMatchedDN(LdapDN matchedDN) {
        this.matchedDN = matchedDN;
    }

    public ArrayList getReferrals() {
        return this.referrals;
    }

    public void addReferral(LdapURL referral) {
        this.referrals.add(referral);
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public int computeLength() {
        int ldapResultLength = 0;
        ldapResultLength = 3;
        ldapResultLength = this.matchedDN == null ? (ldapResultLength += 2) : (ldapResultLength += 1 + Length.getNbBytes((int)LdapDN.getNbBytes(this.matchedDN)) + LdapDN.getNbBytes(this.matchedDN));
        ldapResultLength += 1 + Length.getNbBytes((int)this.errorMessage.getNbBytes()) + this.errorMessage.getNbBytes();
        if (this.referrals != null && this.referrals.size() != 0) {
            Iterator referralIterator = this.referrals.iterator();
            this.referralsLength = 0;
            while (referralIterator.hasNext()) {
                LdapURL referral = (LdapURL)referralIterator.next();
                this.referralsLength += 1 + Length.getNbBytes((int)referral.getNbBytes()) + referral.getNbBytes();
            }
            ldapResultLength += 1 + Length.getNbBytes((int)this.referralsLength) + this.referralsLength;
        }
        return ldapResultLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)10);
            buffer.put((byte)1);
            buffer.put((byte)this.resultCode);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.matchedDN));
        Value.encode((ByteBuffer)buffer, (byte[])this.errorMessage.getBytes());
        if (this.referrals != null && this.referrals.size() != 0) {
            buffer.put((byte)-93);
            buffer.put(Length.getBytes((int)this.referralsLength));
            Iterator referralIterator = this.referrals.iterator();
            while (referralIterator.hasNext()) {
                LdapURL referral = (LdapURL)referralIterator.next();
                Value.encode((ByteBuffer)buffer, (byte[])referral.getBytes());
            }
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("        Ldap Result\n");
        sb.append("            Result code : (").append(this.resultCode).append(')');
        switch (this.resultCode) {
            case 0: {
                sb.append(" success\n");
                break;
            }
            case 1: {
                sb.append(" operationsError\n");
                break;
            }
            case 2: {
                sb.append(" protocolError\n");
                break;
            }
            case 3: {
                sb.append(" timeLimitExceeded\n");
                break;
            }
            case 4: {
                sb.append(" sizeLimitExceeded\n");
                break;
            }
            case 5: {
                sb.append(" compareFalse\n");
                break;
            }
            case 6: {
                sb.append(" compareTrue\n");
                break;
            }
            case 7: {
                sb.append(" authMethodNotSupported\n");
                break;
            }
            case 8: {
                sb.append(" strongAuthRequired\n");
                break;
            }
            case 9: {
                sb.append(" -- 9 reserved --\n");
                break;
            }
            case 10: {
                sb.append(" referral -- new\n");
                break;
            }
            case 11: {
                sb.append(" adminLimitExceeded -- new\n");
                break;
            }
            case 12: {
                sb.append(" unavailableCriticalExtension -- new\n");
                break;
            }
            case 13: {
                sb.append(" confidentialityRequired -- new\n");
                break;
            }
            case 14: {
                sb.append(" saslBindInProgress -- new\n");
                break;
            }
            case 16: {
                sb.append(" noSuchAttribute\n");
                break;
            }
            case 17: {
                sb.append(" undefinedAttributeType\n");
                break;
            }
            case 18: {
                sb.append(" inappropriateMatching\n");
                break;
            }
            case 19: {
                sb.append(" constraintViolation\n");
                break;
            }
            case 20: {
                sb.append(" attributeOrValueExists\n");
                break;
            }
            case 21: {
                sb.append(" invalidAttributeSyntax\n");
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                sb.append(" -- 22-31 unused --\n");
                break;
            }
            case 32: {
                sb.append(" noSuchObject\n");
                break;
            }
            case 33: {
                sb.append(" aliasProblem\n");
                break;
            }
            case 34: {
                sb.append(" invalidDNSyntax\n");
                break;
            }
            case 35: {
                sb.append(" -- 35 reserved for undefined isLeaf --\n");
                break;
            }
            case 36: {
                sb.append(" aliasDereferencingProblem\n");
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                sb.append(" -- 37-47 unused --\n");
                break;
            }
            case 48: {
                sb.append(" inappropriateAuthentication\n");
                break;
            }
            case 49: {
                sb.append(" invalidCredentials\n");
                break;
            }
            case 50: {
                sb.append(" insufficientAccessRights\n");
                break;
            }
            case 51: {
                sb.append(" busy\n");
                break;
            }
            case 52: {
                sb.append(" unavailable\n");
                break;
            }
            case 53: {
                sb.append(" unwillingToPerform\n");
                break;
            }
            case 54: {
                sb.append(" loopDetect\n");
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                sb.append(" -- 55-63 unused --\n");
                break;
            }
            case 64: {
                sb.append(" namingViolation\n");
                break;
            }
            case 65: {
                sb.append(" objectClassViolation\n");
                break;
            }
            case 66: {
                sb.append(" notAllowedOnNonLeaf\n");
                break;
            }
            case 67: {
                sb.append(" notAllowedOnRDN\n");
                break;
            }
            case 68: {
                sb.append(" entryAlreadyExists\n");
                break;
            }
            case 69: {
                sb.append(" objectClassModsProhibited\n");
                break;
            }
            case 70: {
                sb.append(" -- 70 reserved for CLDAP --\n");
                break;
            }
            case 71: {
                sb.append(" affectsMultipleDSAs -- new\n");
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                sb.append(" -- 72-79 unused --\n");
                break;
            }
            case 80: {
                sb.append(" other\n");
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                sb.append(" -- 81-90 reserved for APIs --");
                break;
            }
            default: {
                sb.append("Unknown error code : ").append(this.resultCode);
            }
        }
        sb.append("            Matched DN : '").append(this.matchedDN == null ? "" : this.matchedDN.toString()).append("'\n");
        sb.append("            Error message : '").append(this.errorMessage == null ? "" : this.errorMessage.toString()).append("'\n");
        if (this.referrals.size() != 0) {
            sb.append("            Referrals :\n");
            for (int i = 0; i < this.referrals.size(); ++i) {
                LdapURL referral = (LdapURL)this.referrals.get(i);
                sb.append("                Referral[").append(i).append("] :").append(referral == null ? "" : referral.toString()).append('\n');
            }
        }
        return sb.toString();
    }
}

