/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.asn1.util.BooleanDecoder;
import org.apache.directory.shared.asn1.util.BooleanDecoderException;
import org.apache.directory.shared.ldap.codec.Control;
import org.apache.directory.shared.ldap.codec.ControlValueAction;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.codec.util.LdapStringEncodingException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapControlGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)LdapControlGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new LdapControlGrammar();

    public static IGrammar getInstance() {
        return instance;
    }

    private LdapControlGrammar() {
        this.name = LdapControlGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_CONTROL_STATE][256];
        this.transitions[LdapStatesEnum.CONTROLS_TAG][160] = new GrammarTransition(LdapStatesEnum.CONTROLS_TAG, LdapStatesEnum.CONTROLS_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROLS_VALUE][160] = new GrammarTransition(LdapStatesEnum.CONTROLS_VALUE, LdapStatesEnum.CONTROL_TAG, new GrammarAction("Init Controls"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                ldapMessage.initControl();
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_TAG][48] = new GrammarTransition(LdapStatesEnum.CONTROL_TAG, LdapStatesEnum.CONTROL_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG][48] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_END_TAG, LdapStatesEnum.CONTROL_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_VALUE_TAG][48] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_END_TAG, LdapStatesEnum.CONTROL_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_END_TAG][48] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_END_TAG, LdapStatesEnum.CONTROL_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_VALUE][48] = new GrammarTransition(LdapStatesEnum.CONTROL_VALUE, LdapStatesEnum.CONTROL_TYPE_TAG, new GrammarAction("Add Control"){

            public void action(IAsn1Container container) {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                Control control = new Control();
                ldapMessage.addControl(control);
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_TYPE_TAG][4] = new GrammarTransition(LdapStatesEnum.CONTROL_TYPE_TAG, LdapStatesEnum.CONTROL_TYPE_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_TYPE_VALUE][4] = new GrammarTransition(LdapStatesEnum.CONTROL_TYPE_VALUE, LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG, new GrammarAction("Set Control type"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = ldapMessage.getCurrentControl();
                if (tlv.getLength().getLength() == 0) {
                    log.error("The OID must not be null");
                    throw new DecoderException("The OID must not be null");
                }
                try {
                    new OID(StringTools.utf8ToString(tlv.getValue().getData()));
                }
                catch (DecoderException de) {
                    log.error("The control type " + StringTools.dumpBytes(tlv.getValue().getData()) + " is not a valid OID : " + de.getMessage());
                    throw de;
                }
                try {
                    control.setControlType(new LdapString(tlv.getValue().getData()));
                }
                catch (LdapStringEncodingException lsee) {
                    log.error("The control type " + StringTools.dumpBytes(tlv.getValue().getData()) + " is invalid : " + lsee.getMessage());
                    throw new DecoderException(lsee.getMessage());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Control OID : " + control.getControlType());
                }
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG][1] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG, LdapStatesEnum.CONTROL_CRITICALITY_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_CRITICALITY_VALUE][1] = new GrammarTransition(LdapStatesEnum.CONTROL_CRITICALITY_VALUE, LdapStatesEnum.CONTROL_LOOP_OR_VALUE_TAG, new GrammarAction("Set Control criticality"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Control control = ldapMessage.getCurrentControl();
                Value value = tlv.getValue();
                try {
                    control.setCriticality(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    log.error("The control criticality flag " + StringTools.dumpBytes(value.getData()) + " is invalid : " + bde.getMessage() + ". It should be 0 or 255");
                    throw new DecoderException(bde.getMessage());
                }
                ldapMessageContainer.grammarEndAllowed(true);
                if (IS_DEBUG) {
                    log.debug("Control criticality : " + control.getCriticality());
                }
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_CRITICAL_OR_VALUE_TAG, LdapStatesEnum.CONTROL_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_LOOP_OR_VALUE_TAG][4] = new GrammarTransition(LdapStatesEnum.CONTROL_LOOP_OR_VALUE_TAG, LdapStatesEnum.CONTROL_VALUE_VALUE, null);
        this.transitions[LdapStatesEnum.CONTROL_VALUE_VALUE][4] = new GrammarTransition(LdapStatesEnum.CONTROL_VALUE_VALUE, LdapStatesEnum.CONTROL_LOOP_OR_END_TAG, (GrammarAction)new ControlValueAction());
    }
}

