/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.ber.tlv.Length;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.util.LdapString;
import org.apache.directory.shared.ldap.util.StringTools;

public class Control
extends Asn1Object {
    private LdapString controlType;
    private boolean criticality = false;
    private Object controlValue;
    private byte[] encodedValue;
    private transient int controlLength;

    public String getControlType() {
        return this.controlType == null ? "" : this.controlType.toString();
    }

    public void setControlType(LdapString controlType) {
        this.controlType = controlType;
    }

    public Object getControlValue() {
        if (this.controlValue == null) {
            return StringTools.EMPTY_BYTES;
        }
        if (this.controlValue instanceof String) {
            return StringTools.getBytesUtf8((String)this.controlValue);
        }
        return this.controlValue;
    }

    public void setEncodedValue(byte[] encodedValue) {
        this.encodedValue = encodedValue;
    }

    public byte[] getEncodedValue() {
        if (this.encodedValue == null) {
            return StringTools.EMPTY_BYTES;
        }
        return this.encodedValue;
    }

    public void setControlValue(Object controlValue) {
        this.controlValue = controlValue;
    }

    public boolean getCriticality() {
        return this.criticality;
    }

    public void setCriticality(boolean criticality) {
        this.criticality = criticality;
    }

    public int computeLength() {
        int controlTypeLengh = this.controlType.getNbBytes();
        this.controlLength = 1 + Length.getNbBytes((int)controlTypeLengh) + controlTypeLengh;
        if (this.criticality) {
            this.controlLength += 3;
        }
        if (this.controlValue != null) {
            if (this.controlValue instanceof byte[]) {
                byte[] controlBytes = (byte[])this.controlValue;
                this.controlLength += 1 + Length.getNbBytes((int)controlBytes.length) + controlBytes.length;
            } else if (this.controlValue instanceof String) {
                byte[] controlBytes = StringTools.getBytesUtf8((String)this.controlValue);
                this.controlLength += 1 + Length.getNbBytes((int)controlBytes.length) + controlBytes.length;
            } else if (this.controlValue instanceof Asn1Object) {
                int length = ((Asn1Object)this.controlValue).computeLength();
                this.controlLength += 1 + Length.getNbBytes((int)length) + length;
            } else {
                throw new IllegalStateException("Don't know how to handle control value class " + this.controlValue.getClass());
            }
        }
        return 1 + Length.getNbBytes((int)this.controlLength) + this.controlLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)48);
            buffer.put(Length.getBytes((int)this.controlLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode((ByteBuffer)buffer, (byte[])this.controlType.getBytes());
        if (this.criticality) {
            Value.encode((ByteBuffer)buffer, (boolean)this.criticality);
        }
        if (this.controlValue != null) {
            byte[] controlBytes;
            if (this.controlValue instanceof byte[]) {
                controlBytes = (byte[])this.controlValue;
                this.encodedValue = controlBytes;
            } else if (this.controlValue instanceof String) {
                controlBytes = StringTools.getBytesUtf8((String)this.controlValue);
                this.encodedValue = controlBytes;
            } else if (this.controlValue instanceof Asn1Object) {
                controlBytes = ((Asn1Object)this.controlValue).encode(null).array();
                this.encodedValue = controlBytes;
            } else {
                throw new IllegalStateException("Don't know how to handle control value class " + this.controlValue.getClass());
            }
            Value.encode((ByteBuffer)buffer, (byte[])controlBytes);
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Control\n");
        sb.append("        Control type : '").append(this.controlType != null ? this.controlType.toString() : "null").append("'\n");
        sb.append("        Criticality : '").append(this.criticality).append("'\n");
        if (this.controlValue != null) {
            if (this.controlValue instanceof byte[]) {
                sb.append("        Control value : '").append(StringTools.dumpBytes((byte[])this.controlValue)).append("'\n");
            } else {
                sb.append("        Control value : '").append(this.controlValue).append("'\n");
            }
        }
        return sb.toString();
    }
}

