/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import org.apache.directory.shared.ldap.message.IteratorNamingEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockableAttributeImpl
implements Attribute {
    private static final Logger log = LoggerFactory.getLogger((Class)LockableAttributeImpl.class);
    private static final long serialVersionUID = -5158233254341746514L;
    private final String id;
    private final ArrayList list;

    public LockableAttributeImpl(String id) {
        this.id = id;
        this.list = new ArrayList();
    }

    public LockableAttributeImpl(String id, Object value) {
        this.id = id;
        this.list = new ArrayList();
        this.list.add(value);
    }

    public LockableAttributeImpl(String id, byte[] value) {
        this.id = id;
        this.list = new ArrayList();
        this.list.add(value);
    }

    private LockableAttributeImpl(String id, ArrayList list) {
        this.id = id;
        this.list = list;
    }

    public NamingEnumeration getAll() {
        return new IteratorNamingEnumeration(this.list.iterator());
    }

    public Object get() {
        if (this.list.isEmpty()) {
            return null;
        }
        return this.list.get(0);
    }

    public int size() {
        return this.list.size();
    }

    public String getID() {
        return this.id;
    }

    public boolean contains(Object attrVal) {
        return this.list.contains(attrVal);
    }

    public boolean add(Object attrVal) {
        return this.list.add(attrVal);
    }

    public boolean remove(Object attrVal) {
        return this.list.remove(attrVal);
    }

    public void clear() {
        this.list.clear();
    }

    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException("Extending subclasses may override this if they like!");
    }

    public Object clone() {
        ArrayList l_list = (ArrayList)this.list.clone();
        return new LockableAttributeImpl(this.id, l_list);
    }

    public boolean isOrdered() {
        return true;
    }

    public Object get(int index) {
        return this.list.get(index);
    }

    public Object remove(int index) {
        return this.list.remove(index);
    }

    public void add(int index, Object attrVal) {
        this.list.add(index, attrVal);
    }

    public Object set(int index, Object attrVal) {
        return this.list.set(index, attrVal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute attr = (Attribute)obj;
        if (!this.id.equals(attr.getID())) {
            return false;
        }
        if (attr.size() != this.list.size()) {
            return false;
        }
        for (int ii = 0; ii < attr.size(); ++ii) {
            try {
                if (this.list.contains(attr.get(ii))) continue;
                return false;
            }
            catch (NamingException e) {
                log.warn("Failed to get an attribute from the specifid attribute: " + attr, (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

