/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.add;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.add.AddResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)AddResponseGrammar.class);
    private static IGrammar instance = new AddResponseGrammar();

    private AddResponseGrammar() {
        this.name = AddResponseGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_ADD_RESPONSE_STATE][256];
        this.transitions[LdapStatesEnum.ADD_RESPONSE_TAG][105] = new GrammarTransition(LdapStatesEnum.ADD_RESPONSE_TAG, LdapStatesEnum.ADD_RESPONSE_VALUE, null);
        this.transitions[LdapStatesEnum.ADD_RESPONSE_VALUE][105] = new GrammarTransition(LdapStatesEnum.ADD_RESPONSE_VALUE, LdapStatesEnum.ADD_RESPONSE_LDAP_RESULT, new GrammarAction("Init AddResponse"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                if (tlv.getLength().getLength() == 0) {
                    String msg = "The AddResponse must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                AddResponse addResponse = new AddResponse();
                int expectedLength = tlv.getLength().getLength();
                addResponse.setExpectedLength(expectedLength);
                addResponse.setCurrentLength(0);
                addResponse.setParent(ldapMessage);
                ldapMessage.setProtocolOP(addResponse);
                log.debug("Add Response");
            }
        });
        this.transitions[LdapStatesEnum.ADD_RESPONSE_LDAP_RESULT][10] = new GrammarTransition(LdapStatesEnum.ADD_RESPONSE_LDAP_RESULT, 512, new GrammarAction("Pop allowed"){

            public void action(IAsn1Container container) throws DecoderException {
                container.grammarPopAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

