/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.abandon;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequest;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbandonRequestGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)AbandonRequestGrammar.class);
    private static IGrammar instance = new AbandonRequestGrammar();

    private AbandonRequestGrammar() {
        this.name = AbandonRequestGrammar.class.getName();
        this.statesEnum = LdapStatesEnum.getInstance();
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_ABANDON_REQUEST_STATE][256];
        this.transitions[LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_TAG][80] = new GrammarTransition(LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_TAG, LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_VALUE, null);
        this.transitions[LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_VALUE][80] = new GrammarTransition(LdapStatesEnum.ABANDON_REQUEST_MESSAGE_ID_VALUE, -1, new GrammarAction("Store MessageId"){

            public void action(IAsn1Container container) throws DecoderException {
                LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
                LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
                TLV tlv = ldapMessageContainer.getCurrentTLV();
                Value value = tlv.getValue();
                if (value == null || value.getData() == null) {
                    String msg = "The AbandonRequest messageId must not be null";
                    log.error(msg);
                    throw new DecoderException(msg);
                }
                try {
                    int abandonnedMessageId = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                    AbandonRequest abandonRequest = new AbandonRequest();
                    abandonRequest.setAbandonedMessageId(abandonnedMessageId);
                    ldapMessage.setProtocolOP(abandonRequest);
                    if (log.isDebugEnabled()) {
                        log.debug("AbandonMessage Id has been decoded : {}", (Object)new Integer(abandonnedMessageId));
                    }
                    ldapMessageContainer.grammarEndAllowed(true);
                    ldapMessageContainer.grammarPopAllowed(true);
                    return;
                }
                catch (IntegerDecoderException ide) {
                    log.error("The Abandonned Message Id {} is invalid : {}. The message ID must be between (0 .. 2 147 483 647)", (Object)StringTools.dumpBytes(value.getData()), (Object)ide.getMessage());
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

