/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.Assertion;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterVisitor;

public abstract class AssertionNode
extends AbstractExprNode {
    private final Assertion assertion;
    private final String desc;

    public AssertionNode(Assertion assertion) {
        this(assertion, "ASSERTION");
    }

    public AssertionNode(Assertion assertion, String desc) {
        super(AssertionType.ASSERTION);
        this.desc = desc;
        this.assertion = assertion;
        this.set("count", Long.MAX_VALUE);
    }

    public ExprNode clone() {
        return super.clone();
    }

    public Assertion getAssertion() {
        return this.assertion;
    }

    public boolean isLeaf() {
        return true;
    }

    public StringBuilder printRefinementToBuffer(StringBuilder buf) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(I18n.err((String)"ERR_04145", (Object[])new Object[0]));
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.assertion != null ? this.assertion.hashCode() : 0);
        h = h * 17 + (this.desc != null ? this.desc.hashCode() : 0);
        return h;
    }

    public Object accept(FilterVisitor visitor) {
        return visitor.visit(this);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(@");
        buf.append(this.desc);
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

