/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.entry.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.AbstractEntry;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientAttribute;
import org.apache.directory.shared.ldap.entry.client.ClientEntry;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultClientEntry
extends AbstractEntry<String>
implements ClientEntry {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClientEntry.class);

    public DefaultClientEntry() {
        this.dn = DN.EMPTY_DN;
    }

    public DefaultClientEntry(DN dn) {
        this.dn = dn;
    }

    public DefaultClientEntry(DN dn, String ... upIds) {
        this.dn = dn;
        for (String upId : upIds) {
            this.set(upId);
        }
    }

    public DefaultClientEntry(DN dn, EntryAttribute ... attributes) {
        this.dn = dn;
        for (EntryAttribute attribute : attributes) {
            if (attribute == null) continue;
            this.attributes.put(attribute.getId(), attribute);
        }
    }

    private String getId(String upId) throws IllegalArgumentException {
        String id = StringTools.trim(StringTools.toLowerCase(upId));
        if (id == null || id.length() == 0) {
            String message = I18n.err((String)"ERR_04133", (Object[])new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        return id;
    }

    @Override
    public void add(EntryAttribute ... attributes) throws NamingException {
        for (EntryAttribute attribute : attributes) {
            if (this.contains(attribute)) {
                EntryAttribute existingAttr = this.get(attribute.getId());
                for (Value value : attribute) {
                    existingAttr.add(value);
                }
                continue;
            }
            this.attributes.put(attribute.getId(), (ClientAttribute)attribute);
        }
    }

    @Override
    public void add(String upId, byte[] ... values) throws NamingException {
        String id = this.getId(upId);
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(id);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId);
        } else {
            this.attributes.put(id, new DefaultClientAttribute(upId, values));
        }
    }

    @Override
    public void add(String upId, String ... values) throws NamingException {
        String id = this.getId(upId);
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(id);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId);
        } else {
            this.attributes.put(id, new DefaultClientAttribute(upId, values));
        }
    }

    @Override
    public void add(String upId, Value<?> ... values) throws NamingException {
        String id = this.getId(upId);
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(id);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(upId);
        } else {
            this.attributes.put(id, new DefaultClientAttribute(upId, values));
        }
    }

    @Override
    public Entry clone() {
        DefaultClientEntry clone = (DefaultClientEntry)super.clone();
        if (clone == null) {
            return null;
        }
        if (this.dn != null) {
            clone.setDn((DN)this.dn.clone());
        }
        clone.attributes = (Map)((HashMap)this.attributes).clone();
        clone.attributes.clear();
        for (EntryAttribute attribute : this.attributes.values()) {
            clone.attributes.put(attribute.getId(), attribute.clone());
        }
        return clone;
    }

    @Override
    public boolean contains(EntryAttribute ... attributes) throws NamingException {
        for (EntryAttribute attribute : attributes) {
            if (attribute == null) {
                return this.attributes.size() == 0;
            }
            if (this.attributes.containsKey(attribute.getId())) continue;
            return false;
        }
        return true;
    }

    public boolean contains(String upId) throws NamingException {
        String id = this.getId(upId);
        return this.attributes.containsKey(id);
    }

    @Override
    public boolean contains(String upId, byte[] ... values) {
        String id = this.getId(upId);
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public boolean contains(String upId, String ... values) {
        String id = this.getId(upId);
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public boolean contains(String upId, Value<?> ... values) {
        String id = this.getId(upId);
        EntryAttribute attribute = (EntryAttribute)this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public boolean containsAttribute(String ... attributes) {
        for (String attribute : attributes) {
            String id = this.getId(attribute);
            if (this.attributes.containsKey(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public EntryAttribute get(String alias) {
        try {
            String id = this.getId(alias);
            return (EntryAttribute)this.attributes.get(id);
        }
        catch (IllegalArgumentException iea) {
            LOG.error(I18n.err((String)"ERR_04134", (Object[])new Object[]{alias}));
            return null;
        }
    }

    @Override
    public EntryAttribute put(String upId, byte[] ... values) {
        String id = this.getId(upId);
        DefaultClientAttribute clientAttribute = new DefaultClientAttribute(upId, values);
        return this.attributes.put(id, clientAttribute);
    }

    @Override
    public EntryAttribute put(String upId, String ... values) {
        String id = this.getId(upId);
        DefaultClientAttribute clientAttribute = new DefaultClientAttribute(upId, values);
        return this.attributes.put(id, clientAttribute);
    }

    @Override
    public EntryAttribute put(String upId, Value<?> ... values) {
        String id = this.getId(upId);
        DefaultClientAttribute clientAttribute = new DefaultClientAttribute(upId, values);
        return this.attributes.put(id, clientAttribute);
    }

    @Override
    public List<EntryAttribute> set(String ... upIds) {
        if (upIds == null) {
            String message = I18n.err((String)"ERR_04135", (Object[])new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        ArrayList<EntryAttribute> returnedClientAttributes = new ArrayList<EntryAttribute>();
        for (String upId : upIds) {
            String id = StringTools.trim(StringTools.toLowerCase(upId));
            if (id == null) {
                String message = I18n.err((String)"ERR_04136", (Object[])new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            if (this.attributes.containsKey(id)) {
                returnedClientAttributes.add((EntryAttribute)this.attributes.remove(id));
            }
            DefaultClientAttribute newAttribute = new DefaultClientAttribute(upId);
            this.attributes.put(id, newAttribute);
        }
        return returnedClientAttributes;
    }

    @Override
    public List<EntryAttribute> put(EntryAttribute ... attributes) throws NamingException {
        ArrayList<EntryAttribute> previous = new ArrayList<EntryAttribute>();
        for (EntryAttribute attribute : attributes) {
            String id = attribute.getId();
            if (this.contains(id)) {
                previous.add(this.get(id));
                this.attributes.remove(id);
            }
            this.attributes.put(id, (ClientAttribute)attribute);
        }
        return previous;
    }

    @Override
    public List<EntryAttribute> remove(EntryAttribute ... attributes) throws NamingException {
        ArrayList<EntryAttribute> removedAttributes = new ArrayList<EntryAttribute>();
        for (EntryAttribute attribute : attributes) {
            if (!this.contains(attribute.getId())) continue;
            this.attributes.remove(attribute.getId());
            removedAttributes.add(attribute);
        }
        return removedAttributes;
    }

    @Override
    public List<EntryAttribute> removeAttributes(String ... attributes) {
        if (attributes.length == 0) {
            return null;
        }
        ArrayList<EntryAttribute> removed = new ArrayList<EntryAttribute>(attributes.length);
        for (String attribute : attributes) {
            EntryAttribute attr = this.get(attribute);
            if (attr != null) {
                removed.add((EntryAttribute)this.attributes.remove(attr.getId()));
                continue;
            }
            String message = I18n.err((String)"ERR_04137", (Object[])new Object[]{attribute});
            LOG.warn(message);
        }
        if (removed.size() == 0) {
            return null;
        }
        return removed;
    }

    @Override
    public boolean remove(String upId, byte[] ... values) throws NamingException {
        try {
            String id = this.getId(upId);
            EntryAttribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err((String)"ERR_04138", (Object[])new Object[]{upId}));
            return false;
        }
    }

    @Override
    public boolean remove(String upId, String ... values) throws NamingException {
        try {
            String id = this.getId(upId);
            EntryAttribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err((String)"ERR_04138", (Object[])new Object[]{upId}));
            return false;
        }
    }

    @Override
    public boolean remove(String upId, Value<?> ... values) throws NamingException {
        try {
            String id = this.getId(upId);
            EntryAttribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err((String)"ERR_04138", (Object[])new Object[]{upId}));
            return false;
        }
    }

    @Override
    public Iterator<EntryAttribute> iterator() {
        return Collections.unmodifiableMap(this.attributes).values().iterator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.dn == null) {
            out.writeObject(DN.EMPTY_DN);
        } else {
            out.writeObject(this.dn);
        }
        out.writeInt(this.attributes.size());
        for (EntryAttribute attribute : this.attributes.values()) {
            out.writeObject(attribute);
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dn = (DN)in.readObject();
        int nbAttributes = in.readInt();
        for (int i = 0; i < nbAttributes; ++i) {
            DefaultClientAttribute attribute = (DefaultClientAttribute)in.readObject();
            this.attributes.put(attribute.getId(), attribute);
        }
    }

    public int hashCode() {
        int result = 37;
        result = result * 17 + this.dn.hashCode();
        TreeMap sortedMap = new TreeMap();
        for (String id : this.attributes.keySet()) {
            sortedMap.put(id, this.attributes.get(id));
        }
        for (String id : sortedMap.keySet()) {
            result = result * 17 + ((EntryAttribute)sortedMap.get(id)).hashCode();
        }
        return result;
    }

    @Override
    public boolean hasObjectClass(String objectClass) {
        return this.contains("objectclass", objectClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultClientEntry)) {
            return false;
        }
        DefaultClientEntry other = (DefaultClientEntry)o;
        if (this.dn == null ? other.getDn() != null : !this.dn.equals(other.getDn())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (EntryAttribute attribute : other) {
            if (attribute.equals(this.get(attribute.getId()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientEntry\n");
        sb.append("    dn: ").append(this.dn.getName()).append('\n');
        if (this.containsAttribute("objectClass")) {
            EntryAttribute objectClass = this.get("objectclass");
            sb.append(objectClass);
        }
        if (this.attributes.size() != 0) {
            for (EntryAttribute attribute : this.attributes.values()) {
                if (attribute.getId().equals("objectclass")) continue;
                sb.append(attribute);
            }
        }
        return sb.toString();
    }
}

