/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchedDNAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(MatchedDNAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public MatchedDNAction() {
        super("Store matched DN");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessageCodec ldapMessage = ldapMessageContainer.getLdapMessage();
        LdapResponseCodec response = ldapMessage.getLdapResponse();
        LdapResultCodec ldapResult = response.getLdapResult();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            ldapResult.setMatchedDN(LdapDN.EMPTY_LDAPDN);
        } else {
            ResultCodeEnum resultCode = ldapResult.getResultCode();
            switch (resultCode) {
                case NO_SUCH_OBJECT: 
                case ALIAS_PROBLEM: 
                case INVALID_DN_SYNTAX: 
                case ALIAS_DEREFERENCING_PROBLEM: {
                    byte[] dnBytes = tlv.getValue().getData();
                    try {
                        ldapResult.setMatchedDN(new LdapDN(dnBytes));
                        break;
                    }
                    catch (InvalidNameException ine) {
                        String msg = "Incorrect DN given : " + StringTools.utf8ToString(dnBytes) + " (" + StringTools.dumpBytes(dnBytes) + ") is invalid";
                        log.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        throw new DecoderException("Incorrect DN given : " + ine.getMessage());
                    }
                }
                default: {
                    log.warn("The matched DN should not be set when the result code is one of NoSuchObject, AliasProblem, InvalidDNSyntax or AliasDreferencingProblem");
                    ldapResult.setMatchedDN(LdapDN.EMPTY_LDAPDN);
                }
            }
        }
        if (IS_DEBUG) {
            log.debug("The matchedDN is " + ldapResult.getMatchedDN());
        }
    }
}

