/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACITuple
implements Serializable {
    private static final long serialVersionUID = 4353150626941232371L;
    private final Collection<UserClass> userClasses;
    private final AuthenticationLevel authenticationLevel;
    private final Collection<ProtectedItem> protectedItems;
    private final Set<MicroOperation> microOperations;
    private final boolean grant;
    private final int precedence;

    public ACITuple(Collection<UserClass> userClasses, AuthenticationLevel authenticationLevel, Collection<ProtectedItem> protectedItems, Set<MicroOperation> microOperations, boolean grant, int precedence) {
        if (authenticationLevel == null) {
            throw new NullPointerException("authenticationLevel");
        }
        if (precedence < 0 || precedence > 255) {
            throw new IllegalArgumentException("precedence: " + precedence);
        }
        this.userClasses = Collections.unmodifiableCollection(new ArrayList<UserClass>(userClasses));
        this.authenticationLevel = authenticationLevel;
        this.protectedItems = Collections.unmodifiableCollection(new ArrayList<ProtectedItem>(protectedItems));
        this.microOperations = Collections.unmodifiableSet(new HashSet<MicroOperation>(microOperations));
        this.grant = grant;
        this.precedence = precedence;
    }

    public Collection<UserClass> getUserClasses() {
        return this.userClasses;
    }

    public AuthenticationLevel getAuthenticationLevel() {
        return this.authenticationLevel;
    }

    public Collection<ProtectedItem> getProtectedItems() {
        return this.protectedItems;
    }

    public Set<MicroOperation> getMicroOperations() {
        return this.microOperations;
    }

    public boolean isGrant() {
        return this.grant;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public String toString() {
        return "ACITuple: userClasses=" + this.userClasses + ", " + "authenticationLevel=" + this.authenticationLevel + ", " + "protectedItems=" + this.protectedItems + ", " + (this.grant ? "grants=" : "denials=") + this.microOperations + ", " + "precedence=" + this.precedence;
    }
}

