/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxes;

import java.text.ParseException;
import org.apache.directory.shared.ldap.schema.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class SubtreeSpecificationSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.45";
    private SubtreeSpecificationChecker checker = new SubtreeSpecificationChecker();

    public SubtreeSpecificationSyntaxChecker() {
        super(SC_OID);
    }

    protected SubtreeSpecificationSyntaxChecker(String oid) {
        super(oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        try {
            SubtreeSpecificationChecker subtreeSpecificationChecker = this.checker;
            synchronized (subtreeSpecificationChecker) {
                this.checker.parse(strValue);
            }
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }
}

