/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;

public class CertGenerationObject
extends AbstractAsn1Object {
    private String targetDN;
    private String issuerDN;
    private String subjectDN;
    private String keyAlgorithm;
    private int requestLength = 0;

    public int computeLength() {
        int len = StringTools.getBytesUtf8(this.targetDN).length;
        this.requestLength = 1 + Value.getNbBytes((int)len) + len;
        len = StringTools.getBytesUtf8(this.issuerDN).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        len = StringTools.getBytesUtf8(this.subjectDN).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        len = StringTools.getBytesUtf8(this.keyAlgorithm).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        return 1 + Value.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(Value.getBytes((int)this.requestLength));
        Value.encode((ByteBuffer)bb, (String)this.targetDN);
        Value.encode((ByteBuffer)bb, (String)this.issuerDN);
        Value.encode((ByteBuffer)bb, (String)this.subjectDN);
        Value.encode((ByteBuffer)bb, (String)this.keyAlgorithm);
        return bb;
    }

    public String getTargetDN() {
        return this.targetDN;
    }

    public void setTargetDN(String targetDN) {
        this.targetDN = targetDN;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Certficate Generation Object { ").append(" Target DN: ").append(this.targetDN).append(',');
        sb.append(" Issuer DN: ").append(this.issuerDN).append(',');
        sb.append(" Subject DN: ").append(this.subjectDN).append(',');
        sb.append(" Key Algorithm: ").append(this.keyAlgorithm).append(" }");
        return sb.toString();
    }
}

