/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message.control;

import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.controls.PagedSearchControlCodec;
import org.apache.directory.shared.ldap.message.control.AbstractMutableControlImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagedSearchControl
extends AbstractMutableControlImpl {
    private static final long serialVersionUID = -2356861450876343999L;
    private static final Logger log = LoggerFactory.getLogger(PagedSearchControl.class);
    public static final String CONTROL_OID = "1.2.840.113556.1.4.319";
    private int size;
    private byte[] cookie;

    public PagedSearchControl() {
        this.setID(CONTROL_OID);
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public byte[] getEncodedValue() {
        PagedSearchControlCodec pscc = new PagedSearchControlCodec();
        pscc.setSize(this.size);
        pscc.setCookie(this.cookie);
        try {
            return pscc.encode(null).array();
        }
        catch (EncoderException e) {
            log.error("Failed to encode paged search control", (Throwable)e);
            throw new IllegalStateException("Failed to encode control with encoder.", e);
        }
    }
}

