/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.Arrays;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.util.StringTools;

public class ExtensibleNode
extends LeafNode {
    private byte[] value;
    private String matchingRuleId;
    private boolean dnAttributes = false;

    public ExtensibleNode(String attribute) {
        super(attribute, AssertionType.EXTENSIBLE);
        this.dnAttributes = false;
    }

    public ExtensibleNode(String attribute, String value, String matchingRuleId, boolean dnAttributes) {
        this(attribute, StringTools.getBytesUtf8(value), matchingRuleId, dnAttributes);
    }

    public ExtensibleNode(String attribute, byte[] value, String matchingRuleId, boolean dnAttributes) {
        super(attribute, AssertionType.EXTENSIBLE);
        if (value != null) {
            this.value = new byte[value.length];
            System.arraycopy(value, 0, this.value, 0, value.length);
        } else {
            this.value = null;
        }
        this.matchingRuleId = matchingRuleId;
        this.dnAttributes = dnAttributes;
    }

    public boolean hasDnAttributes() {
        return this.dnAttributes;
    }

    public void setDnAttributes(boolean dnAttributes) {
        this.dnAttributes = dnAttributes;
    }

    public String getMatchingRuleId() {
        return this.matchingRuleId;
    }

    public void setMatchingRuleId(String matchingRuleId) {
        this.matchingRuleId = matchingRuleId;
    }

    public final byte[] getValue() {
        if (this.value == null) {
            return null;
        }
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return copy;
    }

    public final void setValue(String value) {
        this.value = StringTools.getBytesUtf8(value);
    }

    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.dnAttributes ? 1 : 0);
        h = h * 17 + this.matchingRuleId.hashCode();
        h = h * 17 + Arrays.hashCode(this.value);
        return h;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(').append(this.getAttribute());
        buf.append("-");
        buf.append(this.dnAttributes);
        buf.append("-EXTENSIBLE-");
        buf.append(this.matchingRuleId);
        buf.append("-");
        buf.append(StringTools.utf8ToString(this.value));
        buf.append("/");
        buf.append(StringTools.dumpBytes(this.value));
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

