/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import javax.naming.ldap.Control;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.util.StringTools;

public class LdifControl
implements Control {
    private static final long serialVersionUID = 1L;
    private OID oid;
    private boolean criticality;
    private byte[] value;

    public LdifControl(OID oid) {
        this.oid = oid;
        this.criticality = false;
        this.value = null;
    }

    public boolean isCritical() {
        return this.criticality;
    }

    public void setCriticality(boolean criticality) {
        this.criticality = criticality;
    }

    public String getID() {
        return this.oid.toString();
    }

    public void setOid(OID oid) {
        this.oid = oid;
    }

    public byte[] getEncodedValue() {
        if (this.value == null) {
            return null;
        }
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return copy;
    }

    public void setValue(byte[] value) {
        if (value != null) {
            this.value = new byte[value.length];
            System.arraycopy(value, 0, this.value, 0, value.length);
        } else {
            this.value = null;
        }
    }

    public String toString() {
        return "LdifControl : {" + this.oid.toString() + ", " + this.criticality + ", " + StringTools.dumpBytes(this.value) + "}";
    }
}

