/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.ArrayUtils;
import org.apache.directory.shared.ldap.util.Position;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeUtils {
    public static Attribute removeAttribute(AttributeType type, Attributes entry) {
        Attribute attr = entry.get(type.getOid());
        if (attr == null) {
            String[] aliases = type.getNames();
            for (int ii = 0; ii < aliases.length; ++ii) {
                attr = entry.get(aliases[ii]);
                if (attr == null) continue;
                return entry.remove(attr.getID());
            }
        }
        if (attr == null) {
            return null;
        }
        return entry.remove(attr.getID());
    }

    public static final boolean equals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null) {
            return value2 == null;
        }
        if (value1 instanceof byte[]) {
            if (value2 instanceof byte[]) {
                return Arrays.equals((byte[])value1, (byte[])value2);
            }
            return false;
        }
        return value1.equals(value2);
    }

    public static Object cloneValue(Object value) {
        Object newValue = null;
        newValue = value instanceof byte[] ? ((byte[])value).clone() : value;
        return newValue;
    }

    public static final Attribute toAttributeImpl(Attribute attribute) {
        if (attribute instanceof AttributeImpl) {
            return attribute;
        }
        AttributeImpl newAttribute = new AttributeImpl(attribute.getID());
        try {
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMoreElements()) {
                newAttribute.add(AttributeUtils.cloneValue(values.next()));
            }
            return newAttribute;
        }
        catch (NamingException ne) {
            return newAttribute;
        }
    }

    public static final Attributes toAttributesImpl(Attributes attributes) {
        if (attributes instanceof AttributesImpl) {
            return attributes;
        }
        AttributesImpl newAttributes = new AttributesImpl(attributes.isCaseIgnored());
        try {
            NamingEnumeration<? extends Attribute> values = attributes.getAll();
            while (values.hasMoreElements()) {
                Attribute attribute = values.next();
                newAttributes.put(AttributeUtils.toAttributeImpl(attribute));
            }
            return newAttributes;
        }
        catch (NamingException ne) {
            return newAttributes;
        }
    }

    public static final Attribute getAttribute(Attributes attrs, AttributeType type) {
        Attribute attr = attrs.get(type.getOid());
        if (attr != null) {
            return attr;
        }
        if (type.getNames().length == 1 && (attr = attrs.get(type.getNames()[0])) != null) {
            return attr;
        }
        for (String alias : type.getNames()) {
            attr = attrs.get(alias);
            if (attr == null) continue;
            return attr;
        }
        return null;
    }

    public static final ModificationItem getModificationItem(List<ModificationItemImpl> mods, AttributeType type) {
        if (type.getNames().length == 1) {
            for (ModificationItemImpl mod : mods) {
                if (!((ModificationItem)mod).getAttribute().getID().equalsIgnoreCase(type.getNames()[0])) continue;
                return mod;
            }
        }
        for (ModificationItemImpl mod : mods) {
            if (!((ModificationItem)mod).getAttribute().getID().equals(type.getOid())) continue;
            return mod;
        }
        for (int ii = 0; ii < type.getNames().length; ++ii) {
            for (ModificationItemImpl mod : mods) {
                if (!((ModificationItem)mod).getAttribute().getID().equalsIgnoreCase(type.getNames()[ii])) continue;
                return mod;
            }
        }
        return null;
    }

    public static boolean containsValue(Attribute attr, Object compared, AttributeType type) throws NamingException {
        if (attr.contains(compared)) {
            return true;
        }
        MatchingRule matchingRule = type.getEquality();
        Normalizer normalizer = null;
        normalizer = matchingRule != null ? type.getEquality().getNormalizer() : new NoOpNormalizer();
        if (type.getSyntax().isHumanReadable()) {
            String comparedStr = (String)normalizer.normalize(compared);
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (!comparedStr.equals(normalizer.normalize(value))) continue;
                return true;
            }
        } else {
            byte[] comparedBytes = null;
            if (compared instanceof String) {
                if (((String)compared).length() < 3) {
                    return false;
                }
                int state = 1;
                comparedBytes = new byte[((String)compared).length() / 3];
                int pos = 0;
                block6: for (char c : ((String)compared).toCharArray()) {
                    switch (state) {
                        case 1: {
                            if (c != '\\') {
                                return false;
                            }
                            ++state;
                            continue block6;
                        }
                        case 2: {
                            byte high = StringTools.getHexValue(c);
                            if (high == -1) {
                                return false;
                            }
                            comparedBytes[pos] = (byte)(high << 4);
                            ++state;
                            continue block6;
                        }
                        case 3: {
                            byte low = StringTools.getHexValue(c);
                            if (low == -1) {
                                return false;
                            }
                            int n = pos++;
                            comparedBytes[n] = (byte)(comparedBytes[n] + (byte)low);
                            state = 1;
                        }
                    }
                }
            } else {
                comparedBytes = (byte[])compared;
            }
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (!(value instanceof byte[]) || !ArrayUtils.isEquals(comparedBytes, value)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsValueCaseIgnore(Attribute attr, Object value) {
        if (attr.contains(value)) {
            return true;
        }
        try {
            if (value instanceof String) {
                String strVal = (String)value;
                NamingEnumeration<?> attrVals = attr.getAll();
                while (attrVals.hasMoreElements()) {
                    Object attrVal = attrVals.nextElement();
                    if (!(attrVal instanceof String) || !strVal.equalsIgnoreCase((String)attrVal)) continue;
                    return true;
                }
            } else {
                byte[] valueBytes = (byte[])value;
                NamingEnumeration<?> attrVals = attr.getAll();
                while (attrVals.hasMoreElements()) {
                    Object attrVal = attrVals.nextElement();
                    if (!(attrVal instanceof byte[]) || !Arrays.equals((byte[])attrVal, valueBytes)) continue;
                    return true;
                }
            }
        }
        catch (NamingException ne) {
            return false;
        }
        return false;
    }

    public static boolean containsAnyValues(Attribute attr, Object[] compared, AttributeType type) throws NamingException {
        for (int ii = 0; ii < compared.length; ++ii) {
            if (!attr.contains(compared)) continue;
            return true;
        }
        Normalizer normalizer = type.getEquality().getNormalizer();
        if (type.getSyntax().isHumanReadable()) {
            for (int jj = 0; jj < compared.length; ++jj) {
                String comparedStr = (String)normalizer.normalize(compared[jj]);
                for (int ii = attr.size(); ii >= 0; --ii) {
                    String value = (String)attr.get(ii);
                    if (!comparedStr.equals(normalizer.normalize(value))) continue;
                    return true;
                }
            }
        } else {
            for (int jj = 0; jj < compared.length; ++jj) {
                byte[] comparedBytes = (byte[])compared[jj];
                for (int ii = attr.size(); ii >= 0; --ii) {
                    if (!ArrayUtils.isEquals(comparedBytes, attr.get(ii))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Attribute getDifference(Attribute attr0, Attribute attr1) throws NamingException {
        int ii;
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException("Cannot figure out attribute ID if both args are null");
        }
        if (attr0 == null) {
            return new AttributeImpl(attr1.getID());
        }
        if (attr1 == null) {
            return (Attribute)attr0.clone();
        }
        if (!attr0.getID().equalsIgnoreCase(attr1.getID())) {
            throw new IllegalArgumentException("Cannot take difference of attributes with different IDs!");
        }
        String id = attr0.getID();
        AttributeImpl attr = new AttributeImpl(id);
        if (attr0 != null) {
            for (ii = 0; ii < attr0.size(); ++ii) {
                attr.add(attr0.get(ii));
            }
        }
        if (attr1 != null) {
            for (ii = 0; ii < attr1.size(); ++ii) {
                attr.remove(attr1.get(ii));
            }
        }
        return attr;
    }

    public static Attribute getUnion(Attribute attr0, Attribute attr1) throws NamingException {
        int ii;
        String id;
        if (attr0 == null && attr1 == null) {
            throw new IllegalArgumentException("Cannot figure out attribute ID if both args are null");
        }
        if (attr0 == null) {
            id = attr1.getID();
        } else if (attr1 == null) {
            id = attr0.getID();
        } else {
            if (!attr0.getID().equalsIgnoreCase(attr1.getID())) {
                throw new IllegalArgumentException("Cannot take union of attributes with different IDs!");
            }
            id = attr0.getID();
        }
        AttributeImpl attr = new AttributeImpl(id);
        if (attr0 != null) {
            for (ii = 0; ii < attr0.size(); ++ii) {
                attr.add(attr0.get(ii));
            }
        }
        if (attr1 != null) {
            for (ii = 0; ii < attr1.size(); ++ii) {
                attr.add(attr1.get(ii));
            }
        }
        return attr;
    }

    public static Attributes toCaseInsensitive(Attributes attributes) {
        if (attributes == null) {
            return attributes;
        }
        if (attributes instanceof BasicAttributes) {
            if (attributes.isCaseIgnored()) {
                return attributes;
            }
            BasicAttributes newAttrs = new BasicAttributes(true);
            NamingEnumeration<? extends Attribute> attrs = attributes.getAll();
            if (attrs != null) {
                while (attrs.hasMoreElements()) {
                    newAttrs.put((Attribute)attrs.nextElement());
                }
            }
            return newAttrs;
        }
        return attributes;
    }

    public static String toString(String tabs, Attribute attribute) {
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append("Attribute\n");
        if (attribute != null) {
            sb.append(tabs).append("    Type : '").append(attribute.getID()).append("'\n");
            for (int j = 0; j < attribute.size(); ++j) {
                try {
                    Object attr = attribute.get(j);
                    if (attr == null) continue;
                    if (attr instanceof String) {
                        sb.append(tabs).append("        Val[").append(j).append("] : ").append(attr).append(" \n");
                        continue;
                    }
                    if (attr instanceof byte[]) {
                        String string = StringTools.utf8ToString((byte[])attr);
                        sb.append(tabs).append("        Val[").append(j).append("] : ");
                        sb.append(string).append('/');
                        sb.append(StringTools.dumpBytes((byte[])attr));
                        sb.append(" \n");
                        continue;
                    }
                    sb.append(tabs).append("        Val[").append(j).append("] : ").append(attr).append(" \n");
                    continue;
                }
                catch (NamingException ne) {
                    sb.append("Bad attribute : ").append(ne.getMessage());
                }
            }
        }
        return sb.toString();
    }

    public static String toString(Attribute attribute) {
        return AttributeUtils.toString("", attribute);
    }

    public static String toString(String tabs, Attributes attributes) {
        StringBuffer sb = new StringBuffer();
        sb.append(tabs).append("Attributes\n");
        if (attributes != null) {
            NamingEnumeration<? extends Attribute> attributesIterator = attributes.getAll();
            while (attributesIterator.hasMoreElements()) {
                Attribute attribute = (Attribute)attributesIterator.nextElement();
                sb.append(tabs).append(attribute.toString());
            }
        }
        return sb.toString();
    }

    private static void parseOptions(String str, Position pos) throws ParseException {
        while (StringTools.isCharASCII(str, pos.start, ';')) {
            ++pos.start;
            if (!StringTools.isAlphaDigitMinus(str, pos.start)) {
                throw new ParseException("An empty option is not allowed", pos.start);
            }
            ++pos.start;
            while (StringTools.isAlphaDigitMinus(str, pos.start)) {
                ++pos.start;
            }
        }
    }

    private static boolean parseNumber(String filter, Position pos) {
        char c = StringTools.charAt(filter, pos.start);
        switch (c) {
            case '0': {
                ++pos.start;
                return true;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                ++pos.start;
                break;
            }
            default: {
                return false;
            }
        }
        while (StringTools.isDigit(filter, pos.start)) {
            ++pos.start;
        }
        return true;
    }

    public static void parseOID(String str, Position pos) throws ParseException {
        AttributeUtils.parseNumber(str, pos);
        if (!StringTools.isCharASCII(str, pos.start, '.')) {
            throw new ParseException("Invalid OID, missing '.'", pos.start);
        }
        ++pos.start;
        if (!AttributeUtils.parseNumber(str, pos)) {
            throw new ParseException("Invalid OID, missing a number after a '.'", pos.start);
        }
        while (StringTools.isCharASCII(str, pos.start, '.')) {
            ++pos.start;
            if (AttributeUtils.parseNumber(str, pos)) continue;
            throw new ParseException("Invalid OID, missing a number after a '.'", pos.start);
        }
    }

    public static String parseAttribute(String str, Position pos, boolean withOption) throws ParseException {
        char c = StringTools.charAt(str, pos.start);
        if (c == '\u0000') {
            throw new ParseException("Empty attributes", pos.start);
        }
        int start = pos.start++;
        if (StringTools.isAlpha(c)) {
            while (StringTools.isAlphaDigitMinus(str, pos.start)) {
                ++pos.start;
            }
            if (withOption) {
                AttributeUtils.parseOptions(str, pos);
            }
            return str.substring(start, pos.start);
        }
        if (StringTools.isDigit(c)) {
            ++pos.start;
            AttributeUtils.parseOID(str, pos);
            if (withOption) {
                AttributeUtils.parseOptions(str, pos);
            }
            return str.substring(start, pos.start);
        }
        throw new ParseException("Bad char in attribute", pos.start);
    }

    public static String toString(Attributes attributes) {
        return AttributeUtils.toString("", attributes);
    }

    public static void applyModification(Attributes entry, ModificationItem modification) throws NamingException {
        Attribute modAttr = modification.getAttribute();
        String modificationId = modAttr.getID();
        switch (modification.getModificationOp()) {
            case 1: {
                Attribute modifiedAttr = entry.get(modificationId);
                if (modifiedAttr == null) {
                    entry.put(modAttr);
                    break;
                }
                NamingEnumeration<?> values = modAttr.getAll();
                while (values.hasMoreElements()) {
                    modifiedAttr.add(values.nextElement());
                }
                break;
            }
            case 3: {
                if (modAttr.get() == null) {
                    entry.remove(modificationId);
                    break;
                }
                Attribute modifiedAttr = entry.get(modificationId);
                if (modifiedAttr == null) break;
                NamingEnumeration<?> values = modAttr.getAll();
                while (values.hasMoreElements()) {
                    modifiedAttr.remove(values.nextElement());
                }
                if (modifiedAttr.size() != 0) break;
                entry.remove(modifiedAttr.getID());
                break;
            }
            case 2: {
                if (modAttr.get() == null) {
                    entry.remove(modificationId);
                    break;
                }
                entry.put(modAttr);
            }
        }
    }

    public static Object removeValue(Attribute attr, Object compared, AttributeType type) throws NamingException {
        if (attr.contains(compared)) {
            return attr.remove(compared);
        }
        MatchingRule matchingRule = type.getEquality();
        Normalizer normalizer = matchingRule != null ? type.getEquality().getNormalizer() : new NoOpNormalizer();
        if (type.getSyntax().isHumanReadable()) {
            String comparedStr = (String)normalizer.normalize(compared);
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (!comparedStr.equals(normalizer.normalize(value))) continue;
                return attr.remove(value);
            }
        } else {
            byte[] comparedBytes = null;
            if (compared instanceof String) {
                if (((String)compared).length() < 3) {
                    return null;
                }
                int state = 1;
                comparedBytes = new byte[((String)compared).length() / 3];
                int pos = 0;
                block6: for (char c : ((String)compared).toCharArray()) {
                    switch (state) {
                        case 1: {
                            if (c != '\\') {
                                return null;
                            }
                            ++state;
                            continue block6;
                        }
                        case 2: {
                            byte high = StringTools.getHexValue(c);
                            if (high == -1) {
                                return null;
                            }
                            comparedBytes[pos] = (byte)(high << 4);
                            ++state;
                            continue block6;
                        }
                        case 3: {
                            byte low = StringTools.getHexValue(c);
                            if (low == -1) {
                                return null;
                            }
                            int n = pos++;
                            comparedBytes[n] = (byte)(comparedBytes[n] + (byte)low);
                            state = 1;
                        }
                    }
                }
            } else {
                comparedBytes = (byte[])compared;
            }
            NamingEnumeration<?> values = attr.getAll();
            while (values.hasMoreElements()) {
                Object value = values.nextElement();
                if (!(value instanceof byte[]) || !ArrayUtils.isEquals(comparedBytes, value)) continue;
                return attr.remove(value);
            }
        }
        return null;
    }
}

