/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.subtree;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.schema.OidNormalizer;
import org.apache.directory.shared.ldap.subtree.AntlrSubtreeSpecificationParserTokenTypes;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecification;
import org.apache.directory.shared.ldap.subtree.SubtreeSpecificationModifier;
import org.apache.directory.shared.ldap.util.ComponentsMonitor;
import org.apache.directory.shared.ldap.util.OptionalComponentsMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrSubtreeSpecificationParser
extends LLkParser
implements AntlrSubtreeSpecificationParserTokenTypes {
    private static final Logger log = LoggerFactory.getLogger(AntlrSubtreeSpecificationParser.class);
    private NormalizerMappingResolver resolver;
    private Set<LdapDN> chopBeforeExclusions = null;
    private Set<LdapDN> chopAfterExclusions = null;
    private SubtreeSpecificationModifier ssModifier = null;
    private Map<String, OidNormalizer> oidsMap;
    private ComponentsMonitor subtreeSpecificationComponentsMonitor = null;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"end\"", "OPEN_CURLY", "SP", "SEP", "CLOSE_CURLY", "\"base\"", "\"specificExclusions\"", "\"chopBefore\"", "COLON", "\"chopAfter\"", "\"minimum\"", "\"maximum\"", "\"specificationFilter\"", "FILTER", "SAFEUTF8STRING", "INTEGER", "DESCR", "NUMERICOID", "\"item\"", "\"and\"", "\"or\"", "\"not\"", "INTEGER_OR_NUMERICOID", "DOT", "DIGIT", "LDIGIT", "ALPHA", "SAFEUTF8CHAR", "FILTER_VALUE"};

    public void init(Map<String, OidNormalizer> oidsMap) {
        this.oidsMap = oidsMap;
    }

    public void setNormalizerMappingResolver(NormalizerMappingResolver resolver) {
        this.resolver = resolver;
    }

    public boolean isNormalizing() {
        return this.resolver != null;
    }

    private int token2Integer(Token token) throws RecognitionException {
        int i = 0;
        try {
            i = Integer.parseInt(token.getText());
        }
        catch (NumberFormatException e) {
            throw new RecognitionException("Value of INTEGER token " + token.getText() + " cannot be converted to an Integer");
        }
        return i;
    }

    protected AntlrSubtreeSpecificationParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrSubtreeSpecificationParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 1);
    }

    protected AntlrSubtreeSpecificationParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrSubtreeSpecificationParser(TokenStream lexer) {
        this(lexer, 1);
    }

    public AntlrSubtreeSpecificationParser(ParserSharedInputState state) {
        super(state, 1);
        this.tokenNames = _tokenNames;
    }

    public final SubtreeSpecification wrapperEntryPoint() throws RecognitionException, TokenStreamException {
        log.debug("entered wrapperEntryPoint()");
        SubtreeSpecification ss = null;
        SubtreeSpecification tempSs = null;
        tempSs = this.subtreeSpecification();
        this.match(4);
        ss = tempSs;
        return ss;
    }

    public final SubtreeSpecification subtreeSpecification() throws RecognitionException, TokenStreamException {
        log.debug("entered subtreeSpecification()");
        SubtreeSpecification ss = null;
        this.ssModifier = new SubtreeSpecificationModifier();
        this.subtreeSpecificationComponentsMonitor = new OptionalComponentsMonitor(new String[]{"base", "specificExclusions", "minimum", "maximum", "specificationFilter"});
        this.chopBeforeExclusions = new HashSet<LdapDN>();
        this.chopAfterExclusions = new HashSet<LdapDN>();
        this.match(5);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                this.subtreeSpecificationComponent();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 7) {
                    this.match(7);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.subtreeSpecificationComponent();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(8);
        ss = this.ssModifier.getSubtreeSpecification();
        return ss;
    }

    public final void subtreeSpecificationComponent() throws RecognitionException, TokenStreamException {
        log.debug("entered subtreeSpecification()");
        try {
            switch (this.LA(1)) {
                case 9: {
                    this.ss_base();
                    this.subtreeSpecificationComponentsMonitor.useComponent("base");
                    break;
                }
                case 10: {
                    this.ss_specificExclusions();
                    this.subtreeSpecificationComponentsMonitor.useComponent("specificExclusions");
                    break;
                }
                case 14: {
                    this.ss_minimum();
                    this.subtreeSpecificationComponentsMonitor.useComponent("minimum");
                    break;
                }
                case 15: {
                    this.ss_maximum();
                    this.subtreeSpecificationComponentsMonitor.useComponent("maximum");
                    break;
                }
                case 16: {
                    this.ss_specificationFilter();
                    this.subtreeSpecificationComponentsMonitor.useComponent("specificationFilter");
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new RecognitionException(e.getMessage());
        }
    }

    public final void ss_base() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_base()");
        LdapDN base = null;
        this.match(9);
        int _cnt1371 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1371 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1371;
        }
        base = this.distinguishedName();
        this.ssModifier.setBase(base);
    }

    public final void ss_specificExclusions() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_specificExclusions()");
        this.match(10);
        int _cnt1374 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1374 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1374;
        }
        this.specificExclusions();
        this.ssModifier.setChopBeforeExclusions(this.chopBeforeExclusions);
        this.ssModifier.setChopAfterExclusions(this.chopAfterExclusions);
    }

    public final void ss_minimum() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_minimum()");
        int minimum = 0;
        this.match(14);
        int _cnt1400 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1400 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1400;
        }
        minimum = this.baseDistance();
        this.ssModifier.setMinBaseDistance(minimum);
    }

    public final void ss_maximum() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_maximum()");
        int maximum = 0;
        this.match(15);
        int _cnt1403 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1403 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1403;
        }
        maximum = this.baseDistance();
        this.ssModifier.setMaxBaseDistance(maximum);
    }

    public final void ss_specificationFilter() throws RecognitionException, TokenStreamException {
        log.debug("entered ss_specificationFilter()");
        ExprNode filterExpr = null;
        this.match(16);
        int _cnt1406 = 0;
        while (true) {
            if (this.LA(1) != 6) {
                if (_cnt1406 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(6);
            ++_cnt1406;
        }
        switch (this.LA(1)) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                filterExpr = this.refinement();
                break;
            }
            case 17: {
                filterExpr = this.filter();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.ssModifier.setRefinement(filterExpr);
    }

    public final LdapDN distinguishedName() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered distinguishedName()");
        LdapDN name = null;
        try {
            token = this.LT(1);
            this.match(18);
            name = new LdapDN(token.getText());
            if (this.isNormalizing()) {
                name.normalize(this.oidsMap);
            }
            log.debug("recognized a DistinguishedName: " + token.getText());
        }
        catch (Exception e) {
            throw new RecognitionException("dnParser failed for " + token.getText() + " " + e.getMessage());
        }
        return name;
    }

    public final void specificExclusions() throws RecognitionException, TokenStreamException {
        log.debug("entered specificExclusions()");
        this.match(5);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 11: 
            case 13: {
                this.specificExclusion();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                while (this.LA(1) == 7) {
                    this.match(7);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    this.specificExclusion();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                }
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(8);
    }

    public final void specificExclusion() throws RecognitionException, TokenStreamException {
        log.debug("entered specificExclusion()");
        switch (this.LA(1)) {
            case 11: {
                this.chopBefore();
                break;
            }
            case 13: {
                this.chopAfter();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void chopBefore() throws RecognitionException, TokenStreamException {
        log.debug("entered chopBefore()");
        LdapDN chopBeforeExclusion = null;
        this.match(11);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        chopBeforeExclusion = this.distinguishedName();
        this.chopBeforeExclusions.add(chopBeforeExclusion);
    }

    public final void chopAfter() throws RecognitionException, TokenStreamException {
        log.debug("entered chopAfter()");
        LdapDN chopAfterExclusion = null;
        this.match(13);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        chopAfterExclusion = this.distinguishedName();
        this.chopAfterExclusions.add(chopAfterExclusion);
    }

    public final int baseDistance() throws RecognitionException, TokenStreamException {
        Token token = null;
        log.debug("entered baseDistance()");
        int distance = 0;
        token = this.LT(1);
        this.match(19);
        distance = this.token2Integer(token);
        return distance;
    }

    public final ExprNode refinement() throws RecognitionException, TokenStreamException {
        log.debug("entered refinement()");
        AbstractExprNode node = null;
        switch (this.LA(1)) {
            case 22: {
                node = this.item();
                break;
            }
            case 23: {
                node = this.and();
                break;
            }
            case 24: {
                node = this.or();
                break;
            }
            case 25: {
                node = this.not();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return node;
    }

    public final ExprNode filter() throws RecognitionException, TokenStreamException {
        ExprNode filterExpr = null;
        Token filterToken = null;
        log.debug("entered filter()");
        try {
            filterToken = this.LT(1);
            this.match(17);
            filterExpr = FilterParser.parse(filterToken.getText());
        }
        catch (Exception e) {
            throw new RecognitionException("filterParser failed. " + e.getMessage());
        }
        return filterExpr;
    }

    public final String oid() throws RecognitionException, TokenStreamException {
        log.debug("entered oid()");
        String result = null;
        Token token = null;
        token = this.LT(1);
        switch (this.LA(1)) {
            case 20: {
                this.match(20);
                break;
            }
            case 21: {
                this.match(21);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        result = token.getText();
        log.debug("recognized an oid: " + result);
        return result;
    }

    public final LeafNode item() throws RecognitionException, TokenStreamException {
        log.debug("entered item()");
        EqualityNode node = null;
        String oid = null;
        this.match(22);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        oid = this.oid();
        node = new EqualityNode("objectClass", oid);
        return node;
    }

    public final BranchNode and() throws RecognitionException, TokenStreamException {
        log.debug("entered and()");
        AndNode node = null;
        List<ExprNode> children = null;
        this.match(23);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new AndNode(children);
        return node;
    }

    public final BranchNode or() throws RecognitionException, TokenStreamException {
        log.debug("entered or()");
        OrNode node = null;
        List<ExprNode> children = null;
        this.match(24);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new OrNode(children);
        return node;
    }

    public final BranchNode not() throws RecognitionException, TokenStreamException {
        log.debug("entered not()");
        NotNode node = null;
        List<ExprNode> children = null;
        this.match(25);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        this.match(12);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        children = this.refinements();
        node = new NotNode(children);
        return node;
    }

    public final List<ExprNode> refinements() throws RecognitionException, TokenStreamException {
        log.debug("entered refinements()");
        ArrayList<ExprNode> children = null;
        ExprNode child = null;
        ArrayList<ExprNode> tempChildren = new ArrayList<ExprNode>();
        this.match(5);
        while (this.LA(1) == 6) {
            this.match(6);
        }
        switch (this.LA(1)) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                child = this.refinement();
                while (this.LA(1) == 6) {
                    this.match(6);
                }
                tempChildren.add(child);
                while (this.LA(1) == 7) {
                    this.match(7);
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    child = this.refinement();
                    while (this.LA(1) == 6) {
                        this.match(6);
                    }
                    tempChildren.add(child);
                }
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(8);
        children = tempChildren;
        return children;
    }
}

