/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class ObjectNameSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.18060.0.4.0.0.6";
    private static final String REGEXP = "^([a-zA-Z][a-zA-Z0-9-;]*)$";
    private static final Pattern PATTERN = Pattern.compile("^([a-zA-Z][a-zA-Z0-9-;]*)$");

    public ObjectNameSyntaxChecker() {
        super(SC_OID);
    }

    protected ObjectNameSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        if (value == null) {
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        Matcher match = PATTERN.matcher(strValue);
        return match.matches();
    }
}

