/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.parser;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.parser.AttributeTypeLiteral;
import org.apache.directory.shared.ldap.schema.parser.ObjectClassLiteral;
import org.apache.directory.shared.ldap.schema.parser.ParserMonitor;
import org.apache.directory.shared.ldap.schema.parser.antlrOpenLdapSchemaTokenTypes;

public class antlrOpenLdapSchemaParser
extends LLkParser
implements antlrOpenLdapSchemaTokenTypes {
    public static final String[] EMPTY = new String[0];
    private List attributeTypes = new ArrayList();
    private List objectClasses = new ArrayList();
    private ParserMonitor monitor = null;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "WS", "QUOTE", "DIGIT", "DOLLAR", "OPEN_PAREN", "CLOSE_PAREN", "OPEN_BRACKET", "CLOSE_BRACKET", "NUMERIC_STRING", "NUMERICOID", "IDENTIFIER", "DESC", "SYNTAX", "\"END\"", "\"objectclass\"", "\"OBSOLETE\"", "\"ABSTRACT\"", "\"STRUCTURAL\"", "\"AUXILIARY\"", "\"MAY\"", "\"MUST\"", "\"SUP\"", "\"NAME\"", "\"attributetype\"", "\"SINGLE-VALUE\"", "\"COLLECTIVE\"", "\"NO-USER-MODIFICATION\"", "\"EQUALITY\"", "\"SUBSTR\"", "\"ORDERING\"", "\"USAGE\"", "\"userApplications\"", "\"directoryOperation\"", "\"distributedOperation\"", "\"dSAOperation\""};

    public void clear() {
        this.attributeTypes.clear();
        this.objectClasses.clear();
    }

    public List getAttributeTypes() {
        return Collections.unmodifiableList(this.attributeTypes);
    }

    public List getObjectClasses() {
        return Collections.unmodifiableList(this.objectClasses);
    }

    public void setParserMonitor(ParserMonitor monitor) {
        this.monitor = monitor;
    }

    private void matchedProduction(String msg) {
        if (null != this.monitor) {
            this.monitor.matchedProduction(msg);
        }
    }

    protected antlrOpenLdapSchemaParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public antlrOpenLdapSchemaParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 5);
    }

    protected antlrOpenLdapSchemaParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public antlrOpenLdapSchemaParser(TokenStream lexer) {
        this(lexer, 5);
    }

    public antlrOpenLdapSchemaParser(ParserSharedInputState state) {
        super(state, 5);
        this.tokenNames = _tokenNames;
    }

    public final void parseSchema() throws RecognitionException, TokenStreamException {
        block4: while (true) {
            switch (this.LA(1)) {
                case 27: {
                    this.attributeType();
                    continue block4;
                }
                case 18: {
                    this.objectClass();
                    continue block4;
                }
            }
            break;
        }
        this.match(17);
    }

    public final void attributeType() throws RecognitionException, TokenStreamException {
        Token oid = null;
        this.matchedProduction("attributeType()");
        AttributeTypeLiteral type = null;
        this.match(27);
        this.match(8);
        oid = this.LT(1);
        this.match(13);
        type = new AttributeTypeLiteral(oid.getText());
        switch (this.LA(1)) {
            case 26: {
                this.names(type);
                break;
            }
            case 9: 
            case 15: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 15: {
                this.desc(type);
                break;
            }
            case 9: 
            case 16: 
            case 19: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 19: {
                this.match(19);
                type.setObsolete(true);
                break;
            }
            case 9: 
            case 16: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 25: {
                this.superior(type);
                break;
            }
            case 9: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 31: {
                this.equality(type);
                break;
            }
            case 9: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 33: {
                this.ordering(type);
                break;
            }
            case 9: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 32: {
                this.substr(type);
                break;
            }
            case 9: 
            case 16: 
            case 28: 
            case 29: 
            case 30: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 16: {
                this.syntax(type);
                break;
            }
            case 9: 
            case 28: 
            case 29: 
            case 30: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 28: {
                this.match(28);
                type.setSingleValue(true);
                break;
            }
            case 9: 
            case 29: 
            case 30: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 29: {
                this.match(29);
                type.setCollective(true);
                break;
            }
            case 9: 
            case 30: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 30: {
                this.match(30);
                type.setNoUserModification(true);
                break;
            }
            case 9: 
            case 34: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 34: {
                this.usage(type);
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
        this.attributeTypes.add(type);
    }

    public final void objectClass() throws RecognitionException, TokenStreamException {
        Token oid = null;
        this.matchedProduction("objectClass()");
        ObjectClassLiteral objectClass = null;
        this.match(18);
        this.match(8);
        oid = this.LT(1);
        this.match(13);
        objectClass = new ObjectClassLiteral(oid.getText());
        switch (this.LA(1)) {
            case 26: {
                this.objectClassNames(objectClass);
                break;
            }
            case 9: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 15: {
                this.objectClassDesc(objectClass);
                break;
            }
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 19: {
                this.match(19);
                objectClass.setObsolete(true);
                break;
            }
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 25: {
                this.objectClassSuperiors(objectClass);
                break;
            }
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 20: {
                this.match(20);
                objectClass.setClassType(ObjectClassTypeEnum.ABSTRACT);
                break;
            }
            case 21: {
                this.match(21);
                objectClass.setClassType(ObjectClassTypeEnum.STRUCTURAL);
                break;
            }
            case 22: {
                this.match(22);
                objectClass.setClassType(ObjectClassTypeEnum.AUXILIARY);
                break;
            }
            case 9: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 24: {
                this.must(objectClass);
                break;
            }
            case 9: 
            case 23: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 23: {
                this.may(objectClass);
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(9);
        this.objectClasses.add(objectClass);
    }

    public final void objectClassNames(ObjectClassLiteral objectClass) throws RecognitionException, TokenStreamException {
        Token id0 = null;
        Token id1 = null;
        Token id2 = null;
        this.matchedProduction("names(ObjectClassLiteral)");
        ArrayList<String> list = new ArrayList<String>();
        this.match(26);
        switch (this.LA(1)) {
            case 5: {
                this.match(5);
                id0 = this.LT(1);
                this.match(14);
                this.match(5);
                list.add(id0.getText());
                break;
            }
            case 8: {
                this.match(8);
                this.match(5);
                id1 = this.LT(1);
                this.match(14);
                list.add(id1.getText());
                this.match(5);
                while (this.LA(1) == 5) {
                    this.match(5);
                    id2 = this.LT(1);
                    this.match(14);
                    this.match(5);
                    list.add(id2.getText());
                }
                this.match(9);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        objectClass.setNames(list.toArray(EMPTY));
    }

    public final void objectClassDesc(ObjectClassLiteral objectClass) throws RecognitionException, TokenStreamException {
        Token d = null;
        this.matchedProduction("desc(ObjectClassLiteral)");
        d = this.LT(1);
        this.match(15);
        String desc = d.getText().split("'")[1];
        String[] quoted = desc.split("\"");
        if (quoted.length == 1) {
            objectClass.setDescription(desc);
        } else {
            StringBuffer buf = new StringBuffer();
            for (int ii = 0; ii < quoted.length; ++ii) {
                if (ii < quoted.length - 1) {
                    buf.append(quoted[ii]).append("\\").append("\"");
                    continue;
                }
                buf.append(quoted[ii]);
            }
            objectClass.setDescription(buf.toString());
        }
    }

    public final void objectClassSuperiors(ObjectClassLiteral objectClass) throws RecognitionException, TokenStreamException {
        this.matchedProduction("objectClassSuperiors(ObjectClassLiteral)");
        ArrayList list = null;
        this.match(25);
        list = this.woidlist();
        objectClass.setSuperiors(list.toArray(EMPTY));
    }

    public final void must(ObjectClassLiteral objectClass) throws RecognitionException, TokenStreamException {
        this.matchedProduction("must(ObjectClassLiteral)");
        ArrayList list = null;
        this.match(24);
        list = this.woidlist();
        objectClass.setMust(list.toArray(EMPTY));
    }

    public final void may(ObjectClassLiteral objectClass) throws RecognitionException, TokenStreamException {
        this.matchedProduction("may(ObjectClassLiteral)");
        ArrayList list = null;
        this.match(23);
        list = this.woidlist();
        objectClass.setMay(list.toArray(EMPTY));
    }

    public final ArrayList woidlist() throws RecognitionException, TokenStreamException {
        this.matchedProduction("woidlist()");
        ArrayList<String> list = new ArrayList<String>(2);
        String oid = null;
        switch (this.LA(1)) {
            case 13: 
            case 14: {
                oid = this.woid();
                list.add(oid);
                break;
            }
            case 8: {
                this.match(8);
                oid = this.woid();
                list.add(oid);
                while (this.LA(1) == 7) {
                    this.match(7);
                    oid = this.woid();
                    list.add(oid);
                }
                this.match(9);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return list;
    }

    public final String woid() throws RecognitionException, TokenStreamException {
        Token opt1 = null;
        Token opt2 = null;
        String oid = null;
        this.matchedProduction("woid()");
        switch (this.LA(1)) {
            case 13: {
                opt1 = this.LT(1);
                this.match(13);
                oid = opt1.getText();
                break;
            }
            case 14: {
                opt2 = this.LT(1);
                this.match(14);
                oid = opt2.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return oid;
    }

    public final void names(AttributeTypeLiteral type) throws RecognitionException, TokenStreamException {
        Token id0 = null;
        Token id1 = null;
        this.matchedProduction("names(AttributeTypeLiteral)");
        ArrayList<String> list = new ArrayList<String>();
        this.match(26);
        switch (this.LA(1)) {
            case 5: {
                this.match(5);
                id0 = this.LT(1);
                this.match(14);
                this.match(5);
                list.add(id0.getText());
                break;
            }
            case 8: {
                this.match(8);
                int _cnt997 = 0;
                while (true) {
                    if (this.LA(1) != 5) {
                        if (_cnt997 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(5);
                    id1 = this.LT(1);
                    this.match(14);
                    list.add(id1.getText());
                    this.match(5);
                    ++_cnt997;
                }
                this.match(9);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        type.setNames(list.toArray(EMPTY));
    }

    public final void desc(AttributeTypeLiteral type) throws RecognitionException, TokenStreamException {
        Token d = null;
        this.matchedProduction("desc(AttributeTypeLiteral)");
        d = this.LT(1);
        this.match(15);
        String desc = d.getText().split("'")[1];
        String[] quoted = desc.split("\"");
        if (quoted.length == 1) {
            type.setDescription(desc);
        } else {
            StringBuffer buf = new StringBuffer();
            for (int ii = 0; ii < quoted.length; ++ii) {
                if (ii < quoted.length - 1) {
                    buf.append(quoted[ii]).append("\\").append("\"");
                    continue;
                }
                buf.append(quoted[ii]);
            }
            type.setDescription(buf.toString());
        }
    }

    public final void superior(AttributeTypeLiteral type) throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token id = null;
        this.matchedProduction("superior(AttributeTypeLiteral)");
        this.match(25);
        switch (this.LA(1)) {
            case 13: {
                oid = this.LT(1);
                this.match(13);
                type.setSuperior(oid.getText());
                break;
            }
            case 14: {
                id = this.LT(1);
                this.match(14);
                type.setSuperior(id.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void equality(AttributeTypeLiteral type) throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token id = null;
        this.matchedProduction("equality(AttributeTypeLiteral)");
        this.match(31);
        switch (this.LA(1)) {
            case 13: {
                oid = this.LT(1);
                this.match(13);
                type.setEquality(oid.getText());
                break;
            }
            case 14: {
                id = this.LT(1);
                this.match(14);
                type.setEquality(id.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void ordering(AttributeTypeLiteral type) throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token id = null;
        this.matchedProduction("ordering(AttributeTypeLiteral)");
        this.match(33);
        switch (this.LA(1)) {
            case 13: {
                oid = this.LT(1);
                this.match(13);
                type.setOrdering(oid.getText());
                break;
            }
            case 14: {
                id = this.LT(1);
                this.match(14);
                type.setOrdering(id.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void substr(AttributeTypeLiteral type) throws RecognitionException, TokenStreamException {
        Token oid = null;
        Token id = null;
        this.matchedProduction("substr(AttributeTypeLiteral)");
        this.match(32);
        switch (this.LA(1)) {
            case 13: {
                oid = this.LT(1);
                this.match(13);
                type.setSubstr(oid.getText());
                break;
            }
            case 14: {
                id = this.LT(1);
                this.match(14);
                type.setSubstr(id.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void syntax(AttributeTypeLiteral type) throws RecognitionException, TokenStreamException {
        Token token = null;
        this.matchedProduction("syntax(AttributeTypeLiteral)");
        token = this.LT(1);
        this.match(16);
        String[] comps = token.getText().split(" ");
        int index = comps[1].indexOf("{");
        if (index == -1) {
            type.setSyntax(comps[1]);
            return;
        }
        String oid = comps[1].substring(0, index);
        String length = comps[1].substring(index + 1, comps[1].length() - 1);
        type.setSyntax(oid);
        type.setLength(Integer.parseInt(length));
    }

    public final void usage(AttributeTypeLiteral type) throws RecognitionException, TokenStreamException {
        this.matchedProduction("usage(AttributeTypeLiteral)");
        this.match(34);
        switch (this.LA(1)) {
            case 35: {
                this.match(35);
                type.setUsage(UsageEnum.USER_APPLICATIONS);
                break;
            }
            case 36: {
                this.match(36);
                type.setUsage(UsageEnum.DIRECTORY_OPERATION);
                break;
            }
            case 37: {
                this.match(37);
                type.setUsage(UsageEnum.DISTRIBUTED_OPERATION);
                break;
            }
            case 38: {
                this.match(38);
                type.setUsage(UsageEnum.DSA_OPERATION);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }
}

