/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.parser;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.util.List;
import org.apache.directory.shared.ldap.schema.parser.ParserMonitor;
import org.apache.directory.shared.ldap.schema.parser.ParserMonitorAdapter;
import org.apache.directory.shared.ldap.schema.parser.antlrOpenLdapSchemaLexer;
import org.apache.directory.shared.ldap.schema.parser.antlrOpenLdapSchemaParser;
import org.apache.directory.shared.ldap.util.ExceptionUtils;

public class OpenLdapSchemaParser {
    private ParserMonitor monitor = new ParserMonitorAdapter();
    private antlrOpenLdapSchemaParser parser = null;
    private PipedOutputStream parserIn = null;
    byte[] buf = new byte[128];
    private InputStream schemaIn;
    private Thread producerThread;

    public OpenLdapSchemaParser() throws IOException {
        this.init();
    }

    public void init() throws IOException {
        this.parserIn = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream();
        this.parserIn.connect(in);
        antlrOpenLdapSchemaLexer lexer = new antlrOpenLdapSchemaLexer(in);
        this.parser = new antlrOpenLdapSchemaParser(lexer);
    }

    public synchronized void clear() {
        this.parser.clear();
    }

    public List getAttributeTypes() {
        return this.parser.getAttributeTypes();
    }

    public List getObjectClassTypes() {
        return this.parser.getObjectClasses();
    }

    public synchronized void parse(String schemaObject) throws IOException, ParseException {
        if (schemaObject == null || schemaObject.trim().equals("")) {
            throw new ParseException("The schemaObject is either null or is the empty String!", 0);
        }
        this.schemaIn = new ByteArrayInputStream(schemaObject.getBytes());
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        this.invokeParser(schemaObject);
    }

    private void invokeParser(String subject) throws IOException, ParseException {
        try {
            this.monitor.startedParse("starting parse on:\n" + subject);
            this.parser.parseSchema();
            this.monitor.finishedParse("Done parsing!");
        }
        catch (RecognitionException e) {
            String msg = "Parser failure on:\n\t" + subject;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e);
            this.init();
            throw new ParseException(msg, e.getColumn());
        }
        catch (TokenStreamException e2) {
            String msg = "Parser failure on:\n\t" + subject;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e2);
            this.init();
            throw new ParseException(msg, 0);
        }
    }

    public synchronized void parse(InputStream schemaIn) throws IOException, ParseException {
        this.schemaIn = schemaIn;
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        this.invokeParser("schema input stream ==> " + schemaIn.toString());
    }

    public synchronized void parse(File schemaFile) throws IOException, ParseException {
        this.schemaIn = new FileInputStream(schemaFile);
        if (this.producerThread == null) {
            this.producerThread = new Thread(new DataProducer());
        }
        this.producerThread.start();
        this.invokeParser("schema file ==> " + schemaFile.getAbsolutePath());
    }

    public void setParserMonitor(ParserMonitor monitor) {
        this.monitor = monitor;
        this.parser.setParserMonitor(monitor);
    }

    class DataProducer
    implements Runnable {
        DataProducer() {
        }

        public void run() {
            int count = -1;
            try {
                while ((count = OpenLdapSchemaParser.this.schemaIn.read(OpenLdapSchemaParser.this.buf)) != -1) {
                    OpenLdapSchemaParser.this.parserIn.write(OpenLdapSchemaParser.this.buf, 0, count);
                    OpenLdapSchemaParser.this.parserIn.flush();
                }
                OpenLdapSchemaParser.this.parserIn.write("END ".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

