/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import javax.naming.NamingException;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.UsageEnum;

public class DescriptionUtils {
    public static String getDescription(AttributeType attributeType) throws NamingException {
        StringBuffer buf = new StringBuffer("( ");
        buf.append(attributeType.getOid());
        buf.append('\n');
        buf.append("NAME ");
        buf.append(attributeType.getName());
        buf.append('\n');
        if (attributeType.getDescription() != null) {
            buf.append("DESC ");
            buf.append(attributeType.getDescription());
            buf.append('\n');
        }
        if (attributeType.isObsolete()) {
            buf.append("OBSOLETE");
            buf.append('\n');
        }
        buf.append(attributeType.getSuperior().getOid());
        if (attributeType.getEquality() != null) {
            buf.append("EQUALITY ");
            buf.append(attributeType.getEquality().getOid());
            buf.append('\n');
        }
        if (attributeType.getOrdering() != null) {
            buf.append("ORDERING ");
            buf.append(attributeType.getOrdering().getOid());
            buf.append('\n');
        }
        if (attributeType.getSubstr() != null) {
            buf.append("SUBSTR ");
            buf.append(attributeType.getSubstr().getOid());
            buf.append('\n');
        }
        buf.append("SYNTAX ");
        buf.append(attributeType.getSyntax().getOid());
        buf.append('\n');
        if (attributeType.isSingleValue()) {
            buf.append("SINGLE-VALUE");
            buf.append('\n');
        }
        if (attributeType.isCollective()) {
            buf.append("COLLECTIVE");
            buf.append('\n');
        }
        if (attributeType.isCanUserModify()) {
            buf.append("NO-USER-MODIFICATION");
            buf.append('\n');
        }
        buf.append("USAGE ");
        buf.append(UsageEnum.render(attributeType.getUsage()));
        buf.append(" ) ");
        return buf.toString();
    }

    public static String getDescription(DITContentRule dITContentRule) throws NamingException {
        AttributeType[] not;
        AttributeType[] may;
        AttributeType[] must;
        ObjectClass[] aux;
        StringBuffer buf = new StringBuffer("( ");
        buf.append(dITContentRule.getOid());
        buf.append('\n');
        buf.append("NAME ");
        buf.append(dITContentRule.getName());
        buf.append('\n');
        if (dITContentRule.getDescription() != null) {
            buf.append("DESC ");
            buf.append(dITContentRule.getDescription());
            buf.append('\n');
        }
        if (dITContentRule.isObsolete()) {
            buf.append("OBSOLETE");
            buf.append('\n');
        }
        if ((aux = dITContentRule.getAuxObjectClasses()) != null && aux.length > 0) {
            buf.append("AUX\n");
            for (int ii = 0; ii < aux.length; ++ii) {
                buf.append('\t');
                buf.append(aux[ii].getOid());
                buf.append('\n');
            }
        }
        if ((must = dITContentRule.getMustNames()) != null && must.length > 0) {
            buf.append("MUST\n");
            for (int ii = 0; ii < must.length; ++ii) {
                buf.append('\t');
                buf.append(must[ii].getOid());
                buf.append('\n');
            }
        }
        if ((may = dITContentRule.getMayNames()) != null && may.length > 0) {
            buf.append("MAY\n");
            for (int ii = 0; ii < may.length; ++ii) {
                buf.append('\t');
                buf.append(may[ii].getOid());
                buf.append('\n');
            }
        }
        if ((not = dITContentRule.getNotNames()) != null && not.length > 0) {
            buf.append("NOT\n");
            for (int ii = 0; ii < not.length; ++ii) {
                buf.append('\t');
                buf.append(not[ii].getOid());
                buf.append('\n');
            }
        }
        buf.append(" )");
        return buf.toString();
    }

    public static String getDescription(MatchingRule matchingRule) throws NamingException {
        StringBuffer buf = new StringBuffer("( ");
        buf.append(matchingRule.getOid());
        buf.append('\n');
        buf.append("NAME ");
        buf.append(matchingRule.getName());
        buf.append('\n');
        if (matchingRule.getDescription() != null) {
            buf.append("DESC ");
            buf.append(matchingRule.getDescription());
            buf.append('\n');
        }
        if (matchingRule.isObsolete()) {
            buf.append("OBSOLETE");
            buf.append('\n');
        }
        buf.append("SYNTAX ");
        buf.append(matchingRule.getSyntax().getOid());
        buf.append(" ) ");
        return buf.toString();
    }

    public static String getDescription(MatchingRuleUse matchingRuleUse) throws NamingException {
        StringBuffer buf = new StringBuffer("( ");
        buf.append(matchingRuleUse.getMatchingRule().getOid());
        buf.append('\n');
        buf.append("NAME ");
        buf.append(matchingRuleUse.getName());
        buf.append('\n');
        if (matchingRuleUse.getDescription() != null) {
            buf.append("DESC ");
            buf.append(matchingRuleUse.getDescription());
            buf.append('\n');
        }
        if (matchingRuleUse.isObsolete()) {
            buf.append("OBSOLETE");
            buf.append('\n');
        }
        buf.append("APPLIES ");
        AttributeType[] attributeTypes = matchingRuleUse.getApplicableAttributes();
        if (attributeTypes.length == 1) {
            buf.append(attributeTypes[0].getOid());
        } else {
            buf.append("( ");
            buf.append(attributeTypes[0]);
            for (int ii = 1; ii < attributeTypes.length; ++ii) {
                buf.append(" $ ");
                buf.append(attributeTypes[ii]);
            }
            buf.append(" ) ");
        }
        buf.append('\n');
        return buf.toString();
    }

    public static String getDescription(NameForm nameForm) throws NamingException {
        StringBuffer buf = new StringBuffer("( ");
        buf.append(nameForm.getOid());
        buf.append('\n');
        buf.append("NAME ");
        buf.append(nameForm.getName());
        buf.append('\n');
        if (nameForm.getDescription() != null) {
            buf.append("DESC ");
            buf.append(nameForm.getDescription());
            buf.append('\n');
        }
        if (nameForm.isObsolete()) {
            buf.append("OBSOLETE");
            buf.append('\n');
        }
        buf.append("OC ");
        buf.append(nameForm.getObjectClass().getOid());
        buf.append('\n');
        buf.append("MUST\n");
        AttributeType[] must = nameForm.getMustUse();
        for (int ii = 0; ii < must.length; ++ii) {
            buf.append('\t');
            buf.append(must[ii].getOid());
            buf.append('\n');
        }
        AttributeType[] may = nameForm.getMayUse();
        if (may != null && may.length > 0) {
            buf.append("MAY\n");
            for (int ii = 0; ii < must.length; ++ii) {
                buf.append('\t');
                buf.append(may[ii].getOid());
                buf.append('\n');
            }
        }
        buf.append(" )");
        return buf.toString();
    }

    public static String getDescription(ObjectClass objectClass) throws NamingException {
        AttributeType[] may;
        AttributeType[] must;
        ObjectClass[] sups;
        StringBuffer buf = new StringBuffer("( ");
        buf.append(objectClass.getOid());
        buf.append('\n');
        buf.append("NAME ");
        buf.append(objectClass.getName());
        buf.append('\n');
        if (objectClass.getDescription() != null) {
            buf.append("DESC ");
            buf.append(objectClass.getDescription());
            buf.append('\n');
        }
        if (objectClass.isObsolete()) {
            buf.append("OBSOLETE");
            buf.append('\n');
        }
        if ((sups = objectClass.getSuperClasses()) != null && sups.length > 0) {
            buf.append("SUP\n");
            for (int ii = 0; ii < sups.length; ++ii) {
                buf.append('\t');
                buf.append(sups[ii].getOid());
                buf.append('\n');
            }
        }
        if (objectClass.getType() != null) {
            buf.append((Object)objectClass.getType());
            buf.append('\n');
        }
        if ((must = objectClass.getMustList()) != null && must.length > 0) {
            buf.append("MUST\n");
            for (int ii = 0; ii < must.length; ++ii) {
                buf.append('\t');
                buf.append(must[ii].getOid());
                buf.append('\n');
            }
        }
        if ((may = objectClass.getMayList()) != null && may.length > 0) {
            buf.append("MAY\n");
            for (int ii = 0; ii < may.length; ++ii) {
                buf.append('\t');
                buf.append(may[ii].getOid());
                buf.append('\n');
            }
        }
        buf.append(" )");
        return buf.toString();
    }

    public static String getDescription(DITStructureRule dITStructureRule) throws NamingException {
        StringBuffer buf = new StringBuffer("( ");
        buf.append(dITStructureRule.getOid());
        buf.append('\n');
        buf.append("NAME ");
        buf.append(dITStructureRule.getName());
        buf.append('\n');
        if (dITStructureRule.getDescription() != null) {
            buf.append("DESC ");
            buf.append(dITStructureRule.getDescription());
            buf.append('\n');
        }
        if (dITStructureRule.isObsolete()) {
            buf.append("OBSOLETE");
            buf.append('\n');
        }
        buf.append("FORM ");
        buf.append(dITStructureRule.getNameForm().getOid());
        buf.append('\n');
        DITStructureRule[] sups = dITStructureRule.getSuperClasses();
        if (sups != null && sups.length > 0) {
            buf.append("SUP\n");
            for (int ii = 0; ii < sups.length; ++ii) {
                buf.append('\t');
                buf.append(sups[ii].getOid());
                buf.append('\n');
            }
        }
        buf.append(" )");
        return buf.toString();
    }

    public static String getDescription(Syntax syntax) {
        StringBuffer buf = new StringBuffer("( ");
        buf.append(syntax.getOid());
        buf.append('\n');
        if (syntax.getDescription() != null) {
            buf.append("DESC ");
            buf.append(syntax.getDescription());
            buf.append('\n');
        }
        buf.append(" )");
        return buf.toString();
    }
}

