/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifAttributesReader;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.AttributeUtils;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifUtils {
    private static boolean[] LDIF_SAFE_STARTING_CHAR_ALPHABET;
    private static boolean[] LDIF_SAFE_OTHER_CHARS_ALPHABET;
    private static final int DEFAULT_LINE_LENGTH = 80;

    public static boolean isLDIFSafe(String str) {
        char currentChar = str.charAt(0);
        if (currentChar > '\u007f' || !LDIF_SAFE_STARTING_CHAR_ALPHABET[currentChar]) {
            return false;
        }
        for (int i = 1; i < str.length(); ++i) {
            currentChar = str.charAt(i);
            if (currentChar <= '\u007f' && LDIF_SAFE_OTHER_CHARS_ALPHABET[currentChar]) continue;
            return false;
        }
        return currentChar != ' ';
    }

    public static String convertToLdif(Attributes attrs) throws NamingException {
        return LdifUtils.convertToLdif(attrs, 80);
    }

    public static Attributes convertAttributesFromLdif(String ldif) throws NamingException {
        LdifAttributesReader reader = new LdifAttributesReader();
        return reader.parseAttributes(ldif);
    }

    public static String convertToLdif(Attributes attrs, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        NamingEnumeration<? extends Attribute> ne = attrs.getAll();
        while (ne.hasMore()) {
            Attribute attribute = ne.next();
            if (!(attribute instanceof Attribute)) continue;
            sb.append(LdifUtils.convertToLdif(attribute, length));
        }
        return sb.toString();
    }

    public static String convertToLdif(LdifEntry entry) throws NamingException {
        return LdifUtils.convertToLdif(entry, 80);
    }

    public static String convertToLdif(LdifEntry entry, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        if (LdifUtils.isLDIFSafe(entry.getDn())) {
            sb.append(LdifUtils.stripLineToNChars("dn: " + entry.getDn(), length));
        } else {
            sb.append(LdifUtils.stripLineToNChars("dn:: " + LdifUtils.encodeBase64(entry.getDn()), length));
        }
        sb.append('\n');
        sb.append(LdifUtils.stripLineToNChars("changeType: " + (Object)((Object)entry.getChangeType()), length));
        sb.append('\n');
        switch (entry.getChangeType()) {
            case Delete: {
                if (entry.getAttributes() == null) break;
                throw new NamingException("Invalid Entry : a deleted entry should not contain attributes");
            }
            case Add: {
                if (entry.getAttributes() == null) {
                    throw new NamingException("Invalid Entry : a added or modified entry should contain attributes");
                }
                NamingEnumeration<? extends Attribute> ne = entry.getAttributes().getAll();
                while (ne.hasMore()) {
                    Attribute attribute = ne.next();
                    sb.append(LdifUtils.convertToLdif(attribute, length));
                }
                break;
            }
            case ModDn: 
            case ModRdn: {
                if (entry.getAttributes() != null) {
                    throw new NamingException("Invalid Entry : a modifyDN operation entry should not contain attributes");
                }
                sb.append("deleteoldrdn: ");
                if (entry.isDeleteOldRdn()) {
                    sb.append("1");
                } else {
                    sb.append("0");
                }
                sb.append('\n');
                if (!StringTools.isEmpty(entry.getNewSuperior())) {
                    AttributeImpl newSuperior = new AttributeImpl("newsuperior", entry.getNewSuperior());
                    sb.append(LdifUtils.convertToLdif(newSuperior, length));
                }
                AttributeImpl newRdn = new AttributeImpl("newrdn", entry.getNewRdn());
                sb.append(LdifUtils.convertToLdif(newRdn, length));
                break;
            }
            case Modify: {
                for (ModificationItemImpl modification : entry.getModificationItems()) {
                    switch (((ModificationItem)modification).getModificationOp()) {
                        case 1: {
                            sb.append("add: ");
                            break;
                        }
                        case 3: {
                            sb.append("delete: ");
                            break;
                        }
                        case 2: {
                            sb.append("replace: ");
                        }
                    }
                    sb.append(((ModificationItem)modification).getAttribute().getID());
                    sb.append('\n');
                    sb.append(LdifUtils.convertToLdif(((ModificationItem)modification).getAttribute()));
                    sb.append("-\n");
                }
                break;
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private static String encodeBase64(String str) {
        char[] encoded;
        try {
            encoded = Base64.encode(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            encoded = Base64.encode(str.getBytes());
        }
        return new String(encoded);
    }

    public static String convertToLdif(Attribute attr) throws NamingException {
        return LdifUtils.convertToLdif(attr, 80);
    }

    public static String convertToLdif(Attribute attr, int length) throws NamingException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < attr.size(); ++i) {
            StringBuilder lineBuffer = new StringBuilder();
            lineBuffer.append(attr.getID());
            Object value = attr.get(i);
            if (value == null) {
                lineBuffer.append(':');
            } else if (value instanceof byte[]) {
                char[] encoded = Base64.encode((byte[])value);
                lineBuffer.append(":: " + new String(encoded));
            } else if (value instanceof String) {
                String str = (String)value;
                if (!LdifUtils.isLDIFSafe(str)) {
                    lineBuffer.append(":: " + LdifUtils.encodeBase64((String)value));
                } else {
                    lineBuffer.append(": " + value);
                }
            }
            lineBuffer.append("\n");
            sb.append(LdifUtils.stripLineToNChars(lineBuffer.toString(), length));
        }
        return sb.toString();
    }

    public static String stripLineToNChars(String str, int nbChars) {
        int strLength = str.length();
        if (strLength <= nbChars) {
            return str;
        }
        if (nbChars < 2) {
            throw new IllegalArgumentException("The length of each line must be at least 2 chars long");
        }
        int charsPerLine = nbChars - 1;
        int remaining = (strLength - nbChars) % charsPerLine;
        int nbLines = 1 + (strLength - nbChars) / charsPerLine + (remaining == 0 ? 0 : 1);
        int nbCharsTotal = strLength + nbLines + nbLines - 2;
        char[] buffer = new char[nbCharsTotal];
        char[] orig = str.toCharArray();
        int posSrc = 0;
        int posDst = 0;
        System.arraycopy(orig, posSrc, buffer, posDst, nbChars);
        posSrc += nbChars;
        posDst += nbChars;
        for (int i = 0; i < nbLines - 2; ++i) {
            buffer[posDst++] = 10;
            buffer[posDst++] = 32;
            System.arraycopy(orig, posSrc, buffer, posDst, charsPerLine);
            posSrc += charsPerLine;
            posDst += charsPerLine;
        }
        buffer[posDst++] = 10;
        buffer[posDst++] = 32;
        System.arraycopy(orig, posSrc, buffer, posDst, remaining == 0 ? charsPerLine : remaining);
        return new String(buffer);
    }

    public static LdifEntry reverseAdd(LdapDN dn) throws NamingException {
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Delete);
        entry.setDn(dn.getUpName());
        return entry;
    }

    public static LdifEntry reverseDel(LdapDN dn, Attributes deletedEntry) throws NamingException {
        LdifEntry entry = new LdifEntry();
        entry.setDn(dn.getUpName());
        entry.setChangeType(ChangeType.Add);
        NamingEnumeration<? extends Attribute> attributes = deletedEntry.getAll();
        while (attributes.hasMoreElements()) {
            entry.addAttribute((Attribute)attributes.nextElement());
        }
        return entry;
    }

    public static LdifEntry reverseModifyDn(LdapDN newSuperiorDn, LdapDN modifiedDn) throws NamingException {
        LdifEntry entry = new LdifEntry();
        if (newSuperiorDn == null) {
            throw new NullPointerException("newSuperiorDn must not be null");
        }
        if (modifiedDn == null) {
            throw new NullPointerException("modifiedDn must not be null");
        }
        if (modifiedDn.size() == 0) {
            throw new IllegalArgumentException("Don't think about moving the rootDSE.");
        }
        LdapDN currentParent = (LdapDN)modifiedDn.clone();
        currentParent.remove(currentParent.size() - 1);
        LdapDN newDn = (LdapDN)newSuperiorDn.clone();
        newDn.add(modifiedDn.getRdn());
        entry.setChangeType(ChangeType.ModDn);
        entry.setDn(newDn.getUpName());
        entry.setNewSuperior(currentParent.getUpName());
        entry.setDeleteOldRdn(false);
        return entry;
    }

    public static LdifEntry reverseRename(Attributes t0, LdapDN t0_dn, Rdn t1_rdn) throws NamingException {
        LdifEntry entry = new LdifEntry();
        if (t1_rdn == null) {
            throw new NullPointerException("newRdn must not be null");
        }
        if (t0_dn == null) {
            throw new NullPointerException("modifiedDn must not be null");
        }
        if (t0_dn.size() == 0) {
            throw new IllegalArgumentException("Don't think about renaming the rootDSE.");
        }
        LdapDN parent = (LdapDN)t0_dn.clone();
        parent.remove(parent.size() - 1);
        LdapDN newDn = (LdapDN)parent.clone();
        newDn.add(t1_rdn);
        entry.setChangeType(ChangeType.ModRdn);
        entry.setDeleteOldRdn(LdifUtils.reverseDoDeleteOldRdn(t0, t1_rdn));
        entry.setDn(newDn.getUpName());
        entry.setNewRdn(t0_dn.getRdn().getUpName());
        return entry;
    }

    public static LdifEntry reverseModifyRdn(Attributes t0, LdapDN t1_parentDn, LdapDN t0_dn, Rdn t1_rdn) throws NamingException {
        if (t0_dn == null) {
            throw new NullPointerException("t0_dn must not be null");
        }
        if (t0_dn.size() == 0) {
            throw new IllegalArgumentException("Don't think about a move op on the rootDSE.");
        }
        if (t1_parentDn == null) {
            return LdifUtils.reverseRename(t0, t0_dn, t1_rdn);
        }
        if (t1_rdn == null) {
            return LdifUtils.reverseModifyDn(t1_parentDn, t0_dn);
        }
        LdifEntry reverse = new LdifEntry();
        LdapDN reverseNewSuperiorDn = (LdapDN)t0_dn.clone();
        reverseNewSuperiorDn.remove(reverseNewSuperiorDn.size() - 1);
        Rdn reverseNewRdn = t0_dn.getRdn();
        LdapDN reverseDn = (LdapDN)t1_parentDn.clone();
        reverseDn.add(t1_rdn);
        reverse.setDn(reverseDn.getUpName());
        reverse.setNewSuperior(reverseNewSuperiorDn.getUpName());
        reverse.setNewRdn(reverseNewRdn.getUpName());
        reverse.setChangeType(ChangeType.ModRdn);
        reverse.setDeleteOldRdn(LdifUtils.reverseDoDeleteOldRdn(t0, t1_rdn));
        return reverse;
    }

    private static boolean reverseDoDeleteOldRdn(Attributes t0_entry, Rdn t1_rdn) throws NamingException {
        Attribute t0_attr = t0_entry.get(t1_rdn.getUpType());
        return t0_attr == null || !t0_attr.contains(t1_rdn.getUpValue());
    }

    public static LdifEntry reverseModify(LdapDN dn, List<ModificationItemImpl> forwardModifications, Attributes modifiedEntry) throws NamingException {
        Attributes clonedEntry = (Attributes)modifiedEntry.clone();
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Modify);
        entry.setDn(dn.getUpName());
        ArrayList<ModificationItemImpl> reverseModifications = new ArrayList<ModificationItemImpl>();
        block5: for (ModificationItemImpl modification : forwardModifications) {
            switch (((ModificationItem)modification).getModificationOp()) {
                case 1: {
                    Attribute mod = ((ModificationItem)modification).getAttribute();
                    Attribute previous = modifiedEntry.get(mod.getID());
                    if (mod.equals(previous)) continue block5;
                    ModificationItemImpl reverseModification = new ModificationItemImpl(3, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case 3: {
                    ModificationItemImpl reverseModification;
                    Attribute mod = ((ModificationItem)modification).getAttribute();
                    Attribute previous = modifiedEntry.get(mod.getID());
                    if (previous == null) continue block5;
                    if (mod.get() == null) {
                        reverseModification = new ModificationItemImpl(1, previous);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    reverseModification = new ModificationItemImpl(1, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case 2: {
                    ModificationItemImpl reverseModification;
                    Attribute mod = ((ModificationItem)modification).getAttribute();
                    Attribute previous = modifiedEntry.get(mod.getID());
                    if (mod.get() == null) {
                        reverseModification = new ModificationItemImpl(2, previous);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (previous == null) {
                        AttributeImpl emptyAttribute = new AttributeImpl(mod.getID());
                        reverseModification = new ModificationItemImpl(2, emptyAttribute);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    reverseModification = new ModificationItemImpl(2, previous);
                    reverseModifications.add(0, reverseModification);
                }
            }
            AttributeUtils.applyModification(clonedEntry, modification);
        }
        if (reverseModifications.size() == 0) {
            throw new IllegalArgumentException("Could not deduce reverse modifications from provided modifications: " + forwardModifications);
        }
        for (ModificationItemImpl modification : reverseModifications) {
            entry.addModificationItem(modification);
        }
        return entry;
    }

    static {
        int i;
        LDIF_SAFE_STARTING_CHAR_ALPHABET = new boolean[128];
        LDIF_SAFE_OTHER_CHARS_ALPHABET = new boolean[128];
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[13] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[32] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[58] = false;
        LdifUtils.LDIF_SAFE_STARTING_CHAR_ALPHABET[60] = false;
        for (i = 0; i < 128; ++i) {
            LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[i] = true;
        }
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[0] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[10] = false;
        LdifUtils.LDIF_SAFE_OTHER_CHARS_ALPHABET[13] = false;
    }
}

