/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.ldap.message.AttributeImpl;
import org.apache.directory.shared.ldap.message.AttributesImpl;
import org.apache.directory.shared.ldap.message.ScopeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;

public class SearchRequest
extends LdapMessage {
    private LdapDN baseObject;
    private ScopeEnum scope;
    private int derefAliases;
    private int sizeLimit;
    private int timeLimit;
    private boolean typesOnly;
    private Filter filter;
    private Attributes attributes = new AttributesImpl(true);
    private Filter currentFilter;
    private Filter terminalFilter;
    private int searchRequestLength;
    private int attributeDescriptionListLength;

    public int getMessageType() {
        return 15;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String attribute) {
        this.attributes.put(new AttributeImpl(attribute));
    }

    public LdapDN getBaseObject() {
        return this.baseObject;
    }

    public void setBaseObject(LdapDN baseObject) {
        this.baseObject = baseObject;
    }

    public int getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(int derefAliases) {
        this.derefAliases = derefAliases;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    public Filter getTerminalFilter() {
        return this.terminalFilter;
    }

    public void setTerminalFilter(Filter terminalFilter) {
        this.terminalFilter = terminalFilter;
    }

    public void addCurrentFilter(Filter localFilter) throws DecoderException {
        if (this.currentFilter != null) {
            ((ConnectorFilter)this.currentFilter).addFilter(localFilter);
            localFilter.setParent(this.currentFilter);
            if (localFilter instanceof ConnectorFilter) {
                this.currentFilter = localFilter;
            }
        } else {
            this.currentFilter = localFilter;
            this.currentFilter.setParent(this);
            this.filter = localFilter;
        }
    }

    public void setCurrentFilter(Filter filter) {
        this.currentFilter = filter;
    }

    public void unstackFilters(IAsn1Container container) {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        TLV localParent = tlv.getParent();
        Filter localFilter = this.terminalFilter;
        while (localParent != null && localParent.getExpectedLength() == 0) {
            if (localParent.getId() != localFilter.getParent().getTlvId()) {
                localParent = localParent.getParent();
                continue;
            }
            AbstractAsn1Object filterParent = localFilter.getParent();
            if (localFilter instanceof PresentFilter) {
                filterParent = filterParent.getParent();
            } else if (filterParent instanceof Filter) {
                filterParent = filterParent.getParent();
            }
            if (!(filterParent instanceof Filter)) break;
            localFilter = this.currentFilter = (Filter)filterParent;
            localParent = localParent.getParent();
        }
    }

    public int computeLength() {
        this.searchRequestLength = 0;
        this.searchRequestLength += 1 + TLV.getNbBytes((int)LdapDN.getNbBytes(this.baseObject)) + LdapDN.getNbBytes(this.baseObject);
        this.searchRequestLength += 3;
        this.searchRequestLength += 3;
        this.searchRequestLength += 2 + Value.getNbBytes((int)this.sizeLimit);
        this.searchRequestLength += 2 + Value.getNbBytes((int)this.timeLimit);
        this.searchRequestLength += 3;
        this.searchRequestLength += this.filter.computeLength();
        this.attributeDescriptionListLength = 0;
        if (this.attributes != null && this.attributes.size() != 0) {
            NamingEnumeration<? extends Attribute> attributeIterator = this.attributes.getAll();
            while (attributeIterator.hasMoreElements()) {
                Attribute attribute = (Attribute)attributeIterator.nextElement();
                try {
                    int idLength = attribute.getID().getBytes("UTF-8").length;
                    this.attributeDescriptionListLength += 1 + TLV.getNbBytes((int)idLength) + idLength;
                }
                catch (UnsupportedEncodingException uee) {
                    this.attributeDescriptionListLength += 2;
                }
            }
        }
        this.searchRequestLength += 1 + TLV.getNbBytes((int)this.attributeDescriptionListLength) + this.attributeDescriptionListLength;
        return 1 + TLV.getNbBytes((int)this.searchRequestLength) + this.searchRequestLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)99);
            buffer.put(TLV.getBytes((int)this.searchRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])LdapDN.getBytes(this.baseObject));
            Value.encodeEnumerated((ByteBuffer)buffer, (int)this.scope.getValue());
            Value.encodeEnumerated((ByteBuffer)buffer, (int)this.derefAliases);
            Value.encode((ByteBuffer)buffer, (int)this.sizeLimit);
            Value.encode((ByteBuffer)buffer, (int)this.timeLimit);
            Value.encode((ByteBuffer)buffer, (boolean)this.typesOnly);
            this.filter.encode(buffer);
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.attributeDescriptionListLength));
            if (this.attributes != null && this.attributes.size() != 0) {
                NamingEnumeration<? extends Attribute> attributeIterator = this.attributes.getAll();
                while (attributeIterator.hasMoreElements()) {
                    AttributeImpl attribute = (AttributeImpl)attributeIterator.nextElement();
                    Value.encode((ByteBuffer)buffer, (String)attribute.getID());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    private String buildFilter() {
        if (this.filter == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(").append((Object)this.filter).append(")");
        return sb.toString();
    }

    private String buildAttributes() {
        StringBuffer sb = new StringBuffer();
        if (this.attributes != null) {
            NamingEnumeration<? extends Attribute> attrs = this.attributes.getAll();
            boolean isFirst = true;
            if (attrs != null) {
                while (attrs.hasMoreElements()) {
                    Attribute attr = (Attribute)attrs.nextElement();
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(attr != null ? attr.getID() : "<no ID>");
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Request\n");
        sb.append("        Base Object : '").append(this.baseObject).append("'\n");
        sb.append("        Scope : ");
        switch (this.scope) {
            case BASE_OBJECT: {
                sb.append("base object");
                break;
            }
            case SINGLE_LEVEL: {
                sb.append("single level");
                break;
            }
            case WHOLE_SUBTREE: {
                sb.append("whole subtree");
            }
        }
        sb.append("\n");
        sb.append("        Deref Aliases : ");
        switch (this.derefAliases) {
            case 0: {
                sb.append("never Deref Aliases");
                break;
            }
            case 1: {
                sb.append("deref In Searching");
                break;
            }
            case 2: {
                sb.append("deref Finding Base Obj");
                break;
            }
            case 3: {
                sb.append("deref Always");
            }
        }
        sb.append("\n");
        sb.append("        Size Limit : ");
        if (this.sizeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.sizeLimit);
        }
        sb.append("\n");
        sb.append("        Time Limit : ");
        if (this.timeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.timeLimit);
        }
        sb.append("\n");
        sb.append("        Types Only : ").append(this.typesOnly).append("\n");
        sb.append("        Filter : '").append(this.buildFilter()).append("'\n");
        if (this.attributes != null && this.attributes.size() != 0) {
            sb.append("        Attributes : ").append(this.buildAttributes()).append("\n");
        }
        return sb.toString();
    }
}

