/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitAssertionValueFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitAssertionValueFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitAssertionValueFilterAction() {
        super("Initialize Assertion Value filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        AttributeValueAssertionFilter terminalFilter;
        AttributeValueAssertion assertion;
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        byte[] assertionValue = StringTools.EMPTY_BYTES;
        if (tlv.getLength() != 0) {
            assertionValue = tlv.getValue().getData();
        }
        if (ldapMessageContainer.isBinary((assertion = (terminalFilter = (AttributeValueAssertionFilter)searchRequest.getTerminalFilter()).getAssertion()).getAttributeDesc())) {
            assertion.setAssertionValue(assertionValue);
        } else {
            assertion.setAssertionValue(StringTools.utf8ToString(assertionValue));
        }
        searchRequest.unstackFilters(container);
        if (IS_DEBUG) {
            log.debug("Initialize Assertion Value filter");
        }
    }
}

