/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.codec.stateful.examples;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.stateful.AbstractStatefulDecoder;

public class HexDecoder
extends AbstractStatefulDecoder {
    private ByteBuffer decoded = ByteBuffer.allocate(128);
    private byte lsn;
    private byte msn;
    private boolean expectingMsn = true;

    public void decode(Object chunk) throws DecoderException {
        ByteBuffer encoded = (ByteBuffer)chunk;
        if (encoded == null || !encoded.hasRemaining()) {
            return;
        }
        while (encoded.hasRemaining()) {
            if (!this.decoded.hasRemaining()) {
                this.decoded.flip();
                super.decodeOccurred(this.decoded);
                this.decoded.clear();
            }
            if (this.expectingMsn) {
                this.msn = encoded.get();
                this.expectingMsn = false;
            } else {
                this.lsn = encoded.get();
                this.expectingMsn = true;
            }
            if (!this.expectingMsn) continue;
            byte bite = this.getNibble(this.lsn);
            bite = (byte)(bite | this.getNibble(this.msn) << 4);
            this.decoded.put(bite);
        }
        if (this.expectingMsn) {
            this.decoded.flip();
            super.decodeOccurred(this.decoded);
            this.decoded.clear();
        }
    }

    private byte getNibble(byte ch) throws DecoderException {
        if (ch > 64 && ch < 91) {
            ch = (byte)(ch - 32);
        }
        switch (ch) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 97: {
                return 10;
            }
            case 98: {
                return 11;
            }
            case 99: {
                return 12;
            }
            case 100: {
                return 13;
            }
            case 101: {
                return 14;
            }
            case 102: {
                return 15;
            }
        }
        throw new DecoderException("non-hex character '" + (char)ch + "' encountered");
    }
}

