/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.tlv;

import java.io.Serializable;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;

public class Tag
implements Cloneable,
Serializable {
    public static final long serialVersionUID = 1L;
    public static final transient int CONSTRUCTED_FLAG = 32;
    public static final transient int SHORT_MASK = 31;
    public static final transient int LONG_MASK = 127;
    public static final transient int LONG_FLAG = 128;
    public static final transient int ONE_OCTET_IDMAX = 30;
    public static final transient int TWO_OCTET_IDMAX = 127;
    public static final transient int THREE_OCTET_IDMAX = 16383;
    public static final transient int FOUR_OCTET_IDMAX = 0x1FFFFF;
    public static final transient int TAG_MAX_FLAG = 0x4000000;
    public static final transient int TYPE_CLASS_UNIVERSAL = 0;
    public static final transient int TYPE_CLASS_APPLICATION = 1;
    public static final transient int TYPE_CLASS_CONTEXT_SPECIFIC = 2;
    public static final transient int TYPE_CLASS_PRIVATE = 3;
    public static final transient int TYPE_CLASS_MASK = 192;
    public static final transient int MAX_TAG_BYTES = 5;
    public static final int[] TYPE_CLASS = new int[]{0, 1, 2, 3};
    private int id;
    private int size;
    private boolean isPrimitive;
    private int typeClass;
    private byte[] tagBytes = new byte[]{0, 0, 0, 0, 0};
    private int bytePos = 0;

    public void reset() {
        this.id = 0;
        this.size = 0;
        this.isPrimitive = false;
        this.typeClass = 1;
        this.tagBytes[0] = 0;
        this.tagBytes[1] = 0;
        this.tagBytes[2] = 0;
        this.tagBytes[3] = 0;
        this.tagBytes[4] = 0;
        this.bytePos = 0;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void incTagSize() {
        ++this.size;
    }

    public int getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(int typeClass) {
        this.typeClass = typeClass;
    }

    public boolean isConstructed() {
        return !this.isPrimitive;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isUniversal() {
        return this.typeClass == 0;
    }

    public boolean isApplication() {
        return this.typeClass == 1;
    }

    public boolean isPrivate() {
        return this.typeClass == 3;
    }

    public boolean isContextual() {
        return this.typeClass == 2;
    }

    public void setPrimitive(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    public void addByte(byte octet) {
        this.tagBytes[this.bytePos++] = octet;
    }

    public byte getTagByte() {
        return this.tagBytes[0];
    }

    public byte[] getTagBytes() {
        return this.tagBytes;
    }

    public byte getTagBytes(int pos) {
        return this.tagBytes[pos];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TAG[");
        if (this.isPrimitive) {
            sb.append("PRIMITIVE, ");
        } else {
            sb.append("CONSTRUCTED, ");
        }
        switch (this.typeClass) {
            case 1: {
                sb.append("APPLICATION, ");
                break;
            }
            case 0: {
                sb.append("UNIVERSAL, ").append(UniversalTag.toString(this.id));
                break;
            }
            case 3: {
                sb.append("PRIVATE, ").append(this.id);
                break;
            }
            case 2: {
                sb.append("CONTEXTUAL, ").append(this.id);
            }
        }
        sb.append("](size=").append(this.size).append(")");
        return sb.toString();
    }
}

