/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERObject;
import org.apache.directory.shared.asn1.der.OIDTokenizer;

public class DERObjectIdentifier
extends DERObject {
    String identifier;

    DERObjectIdentifier(byte[] bytes) {
        super(6, bytes);
        StringBuffer objId = new StringBuffer();
        long value = 0L;
        boolean first = true;
        int i = 0;
        while (i != bytes.length) {
            int b = bytes[i] & 0xFF;
            value = value * 128L + (long)(b & 0x7F);
            if ((b & 0x80) == 0) {
                if (first) {
                    switch ((int)value / 40) {
                        case 0: {
                            objId.append('0');
                            break;
                        }
                        case 1: {
                            objId.append('1');
                            value -= 40L;
                            break;
                        }
                        default: {
                            objId.append('2');
                            value -= 80L;
                        }
                    }
                    first = false;
                }
                objId.append('.');
                objId.append(Long.toString(value));
                value = 0L;
            }
            ++i;
        }
        this.identifier = objId.toString();
    }

    private void writeField(OutputStream out, long fieldValue) throws IOException {
        if (fieldValue >= 128L) {
            if (fieldValue >= 16384L) {
                if (fieldValue >= 0x200000L) {
                    if (fieldValue >= 0x10000000L) {
                        if (fieldValue >= 8L) {
                            if (fieldValue >= 1024L) {
                                if (fieldValue >= 131072L) {
                                    if (fieldValue >= 0x1000000L) {
                                        out.write((int)(fieldValue >> 56) | 0x80);
                                    }
                                    out.write((int)(fieldValue >> 49) | 0x80);
                                }
                                out.write((int)(fieldValue >> 42) | 0x80);
                            }
                            out.write((int)(fieldValue >> 35) | 0x80);
                        }
                        out.write((int)(fieldValue >> 28) | 0x80);
                    }
                    out.write((int)(fieldValue >> 21) | 0x80);
                }
                out.write((int)(fieldValue >> 14) | 0x80);
            }
            out.write((int)(fieldValue >> 7) | 0x80);
        }
        out.write((int)fieldValue & 0x7F);
    }

    public void encode(ASN1OutputStream out) throws IOException {
        OIDTokenizer tok = new OIDTokenizer(this.identifier);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        this.writeField(baos, Integer.parseInt(tok.nextToken()) * 40 + Integer.parseInt(tok.nextToken()));
        while (tok.hasMoreTokens()) {
            this.writeField(baos, Long.parseLong(tok.nextToken()));
        }
        aos.close();
        byte[] bytes = baos.toByteArray();
        out.writeEncoded(6, bytes);
    }
}

