/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber;

import java.nio.ByteBuffer;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.tlv.ITLVBerDecoderMBean;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asn1Decoder
implements ITLVBerDecoderMBean {
    private static final Logger log;
    private static final boolean IS_DEBUG;
    private static final boolean MORE = true;
    private static final boolean END = false;
    private boolean indefiniteLengthAllowed = false;
    private int maxLengthLength = 1;
    private int maxTagLength = 1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.directory.shared.asn1.ber.Asn1Decoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        IS_DEBUG = log.isDebugEnabled();
    }

    private boolean treatTagStartState(ByteBuffer stream, IAsn1Container container) throws DecoderException, NamingException {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = new TLV(container.getNewTlvId());
            tlv.setTag(octet);
            container.setCurrentTLV(tlv);
            tlv.setParent(container.getParentTLV());
            container.setState(8);
            if (IS_DEBUG) {
                if (tlv != null) {
                    byte tag = container.getCurrentTLV().getTag();
                    log.debug("Tag {} has been decoded", (Object)Asn1StringUtils.dumpByte(tag));
                } else {
                    log.debug("Tag has been decoded, but is null");
                }
            }
            return true;
        }
        return false;
    }

    private void dumpTLVTree(IAsn1Container container) {
        StringBuffer sb = new StringBuffer();
        TLV current = container.getCurrentTLV();
        sb.append("TLV").append(Asn1StringUtils.dumpByte(current.getTag())).append("(").append(current.getExpectedLength()).append(")");
        current = current.getParent();
        while (current != null) {
            sb.append("-TLV").append(Asn1StringUtils.dumpByte(current.getTag())).append("(").append(current.getExpectedLength()).append(")");
            current = current.getParent();
        }
        if (IS_DEBUG) {
            log.debug("TLV Tree : {}", (Object)sb.toString());
        }
    }

    private boolean isTLVDecoded(IAsn1Container container) {
        TLV current = container.getCurrentTLV();
        TLV parent = current.getParent();
        while (parent != null) {
            if (parent.getExpectedLength() != 0) {
                return false;
            }
            parent = parent.getParent();
        }
        Value value = current.getValue();
        if (value != null && value.getData() != null) {
            return current.getExpectedLength() == value.getData().length;
        }
        return current.getExpectedLength() == 0;
    }

    private boolean treatLengthStartState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = container.getCurrentTLV();
            if ((octet & 0x80) == 0) {
                tlv.setLength(octet);
                tlv.setLengthNbBytes(1);
                container.setState(32);
            } else if ((octet & 0x7F) != 127) {
                int expectedLength = octet & 0x7F;
                if (expectedLength > 4) {
                    log.error("Overflow : can't have more than 4 bytes long length");
                    throw new DecoderException("Overflow : can't have more than 4 bytes long length");
                }
                tlv.setLength(0);
                tlv.setLengthNbBytes(1 + expectedLength);
                tlv.setLengthBytesRead(1);
                container.setState(16);
            } else {
                log.error("Length reserved extension used");
                throw new DecoderException("Length reserved extension used");
            }
            return true;
        }
        return false;
    }

    private boolean treatLengthPendingState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            TLV tlv = container.getCurrentTLV();
            int length = tlv.getLength();
            while (tlv.getLengthBytesRead() < tlv.getLengthNbBytes()) {
                byte octet = stream.get();
                if (IS_DEBUG) {
                    log.debug("  current byte : {}", (Object)Asn1StringUtils.dumpByte(octet));
                }
                tlv.incLengthBytesRead();
                length = length << 8 | octet & 0xFF;
                if (stream.hasRemaining()) continue;
                tlv.setLength(length);
                if (tlv.getLengthBytesRead() < tlv.getLengthNbBytes()) {
                    container.setState(16);
                    return false;
                }
                container.setState(32);
                return true;
            }
            tlv.setLength(length);
            container.setState(32);
            return true;
        }
        return false;
    }

    private String getParentLength(TLV tlv) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TLV expected length stack : ");
        while (true) {
            if (tlv == null) break;
            buffer.append(" - ").append(tlv.getExpectedLength());
            tlv = tlv.getParent();
        }
        buffer.append(" - null");
        return buffer.toString();
    }

    private void treatLengthEndState(IAsn1Container container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        int length = tlv.getLength();
        TLV parentTLV = container.getParentTLV();
        if (IS_DEBUG) {
            log.debug("Parent length : {}", (Object)this.getParentLength(parentTLV));
        }
        if (parentTLV == null) {
            tlv.setExpectedLength(length);
            container.setParentTLV(tlv);
            if (IS_DEBUG) {
                if (tlv != null) {
                    log.debug("Root TLV[{}]", (Object)new Integer(length));
                } else {
                    log.debug("Root TLV[ null ]");
                }
            }
        } else {
            int currentLength;
            int expectedLength = parentTLV.getExpectedLength();
            if (expectedLength < (currentLength = tlv.getSize())) {
                log.error("tlv[{}, {}]", (Object)new Integer(expectedLength), (Object)new Integer(currentLength));
                throw new DecoderException("The current Value length is above the expected length");
            }
            if (expectedLength == currentLength) {
                parentTLV.setExpectedLength(0);
                if (tlv.isConstructed()) {
                    if (length == 0) {
                        while (parentTLV != null) {
                            if (parentTLV.getExpectedLength() != 0) break;
                            parentTLV = parentTLV.getParent();
                        }
                        container.setParentTLV(parentTLV);
                    } else {
                        container.setParentTLV(tlv);
                    }
                    tlv.setParent(parentTLV);
                    tlv.setExpectedLength(length);
                } else {
                    tlv.setExpectedLength(length);
                    while (parentTLV != null) {
                        if (parentTLV.getExpectedLength() != 0) break;
                        parentTLV = parentTLV.getParent();
                    }
                    container.setParentTLV(parentTLV);
                }
            } else {
                parentTLV.setExpectedLength(expectedLength - currentLength);
                tlv.setExpectedLength(length);
                if (tlv.isConstructed()) {
                    tlv.setParent(parentTLV);
                    container.setParentTLV(tlv);
                }
            }
        }
        if (IS_DEBUG) {
            log.debug("Length {} has been decoded", (Object)new Integer(length));
        }
        if (length == 0) {
            container.setState(512);
        } else {
            container.setState(64);
        }
    }

    private boolean treatValueStartState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        TLV currentTlv = container.getCurrentTLV();
        if (TLV.isConstructed(currentTlv.getTag())) {
            container.setState(512);
            return true;
        }
        int length = currentTlv.getLength();
        int nbBytes = stream.remaining();
        if (nbBytes < length) {
            currentTlv.getValue().init(length);
            currentTlv.getValue().setData(stream);
            container.setState(128);
            return false;
        }
        currentTlv.getValue().init(length);
        stream.get(currentTlv.getValue().getData(), 0, length);
        container.setState(512);
        return true;
    }

    private boolean treatValuePendingState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        int nbBytes;
        TLV currentTlv = container.getCurrentTLV();
        int length = currentTlv.getLength();
        int currentLength = currentTlv.getValue().getCurrentLength();
        if (currentLength + (nbBytes = stream.remaining()) < length) {
            currentTlv.getValue().addData(stream);
            container.setState(128);
            return false;
        }
        int remaining = length - currentLength;
        byte[] data = new byte[remaining];
        stream.get(data, 0, remaining);
        currentTlv.getValue().addData(data);
        container.setState(512);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean treatTLVDoneState(ByteBuffer stream, IAsn1Container container) throws DecoderException, NamingException {
        if (IS_DEBUG) {
            this.dumpTLVTree(container);
        }
        container.getGrammar().executeAction(container);
        if (!this.isTLVDecoded(container)) {
            container.setState(0);
            return stream.hasRemaining();
        }
        if (container.getState() == -1) {
            container.setState(1024);
            return stream.hasRemaining();
        }
        if (container.isGrammarEndAllowed()) {
            container.setState(1024);
            return stream.hasRemaining();
        }
        log.error("The PDU is decoded, but we should have had more TLVs");
        throw new DecoderException("Truncated PDU. Some elements are lacking, accordingly to the grammar");
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "TAG_STATE_START";
            }
            case 2: {
                return "TAG_STATE_END";
            }
            case 4: {
                return "TAG_STATE_OVERFLOW";
            }
            case 8: {
                return "LENGTH_STATE_START";
            }
            case 16: {
                return "LENGTH_STATE_PENDING";
            }
            case 32: {
                return "LENGTH_STATE_END";
            }
            case 64: {
                return "VALUE_STATE_START";
            }
            case 128: {
                return "VALUE_STATE_PENDING";
            }
            case 512: {
                return "TLV_STATE_DONE";
            }
        }
        return "UNKNOWN_STATE";
    }

    public void decode(ByteBuffer stream, IAsn1Container container) throws DecoderException, NamingException {
        boolean hasRemaining = stream.hasRemaining();
        if (IS_DEBUG) {
            log.debug(">>>==========================================");
            log.debug("--> Decoding a PDU");
            log.debug(">>>------------------------------------------");
        }
        while (hasRemaining) {
            if (IS_DEBUG) {
                log.debug("--- State = {} ---", (Object)this.stateToString(container.getState()));
                if (stream.hasRemaining()) {
                    byte octet = stream.get(stream.position());
                    log.debug("  current byte : {}", (Object)Asn1StringUtils.dumpByte(octet));
                } else {
                    log.debug("  no more byte to decode in the stream");
                }
            }
            switch (container.getState()) {
                case 0: {
                    container.grammarEndAllowed(false);
                    hasRemaining = this.treatTagStartState(stream, container);
                    break;
                }
                case 8: {
                    hasRemaining = this.treatLengthStartState(stream, container);
                    break;
                }
                case 16: {
                    hasRemaining = this.treatLengthPendingState(stream, container);
                    break;
                }
                case 32: {
                    this.treatLengthEndState(container);
                    break;
                }
                case 64: {
                    hasRemaining = this.treatValueStartState(stream, container);
                    break;
                }
                case 128: {
                    hasRemaining = this.treatValuePendingState(stream, container);
                    break;
                }
                case 256: {
                    hasRemaining = stream.hasRemaining();
                    break;
                }
                case 512: {
                    hasRemaining = this.treatTLVDoneState(stream, container);
                    break;
                }
                case 1024: {
                    log.warn("The PDU has been fully decoded but there are still bytes in the buffer.");
                    hasRemaining = false;
                }
            }
        }
        if (IS_DEBUG) {
            log.debug("<<<------------------------------------------");
            if (container.getState() == 1024) {
                if (container.getCurrentTLV() != null) {
                    log.debug("<-- Stop decoding : {}", (Object)container.getCurrentTLV().toString());
                } else {
                    log.debug("<-- Stop decoding : null current TLV");
                }
            } else if (container.getCurrentTLV() != null) {
                log.debug("<-- End decoding : {}", (Object)container.getCurrentTLV().toString());
            } else {
                log.debug("<-- End decoding : null current TLV");
            }
            log.debug("<<<==========================================");
        }
    }

    public int getMaxLengthLength() {
        return this.maxLengthLength;
    }

    public int getMaxTagLength() {
        return this.maxTagLength;
    }

    public void disallowIndefiniteLength() {
        this.indefiniteLengthAllowed = false;
    }

    public void allowIndefiniteLength() {
        this.indefiniteLengthAllowed = true;
    }

    public boolean isIndefiniteLengthAllowed() {
        return this.indefiniteLengthAllowed;
    }

    public void setMaxLengthLength(int maxLengthLength) throws DecoderException {
        if (this.indefiniteLengthAllowed && maxLengthLength > 126) {
            throw new DecoderException("Length above 126 bytes are not allowed for a definite form Length");
        }
        this.maxLengthLength = maxLengthLength;
    }

    public void setMaxTagLength(int maxTagLength) {
        this.maxTagLength = maxTagLength;
    }
}

