/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber.tlv;

import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;

public class TLV {
    private byte tag = 0;
    private int length = 0;
    private int lengthNbBytes = 0;
    private int LengthBytesRead;
    private Value value = new Value();
    private TLV parent;
    private int expectedLength = 0;
    public static final byte CONSTRUCTED_FLAG = 32;
    public static final byte TYPE_CLASS_MASK = -64;
    public static final byte TYPE_CLASS_UNIVERSAL = 0;
    public static final int SHORT_MASK = 31;
    public static final transient int LENGTH_LONG_FORM = 128;
    public static final transient int LENGTH_EXTENSION_RESERVED = 127;
    public static final transient int LENGTH_SHORT_MASK = 127;

    public static boolean isConstructed(byte tag) {
        return (tag & 0x20) != 0;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public static boolean isPrimitive(byte tag) {
        return (tag & 0x20) == 0;
    }

    public static boolean isUniversal(byte tag) {
        return (tag & 0xFFFFFFC0) == 0;
    }

    public void reset() {
        this.tag = 0;
        this.length = 0;
        this.lengthNbBytes = 0;
        this.value.reset();
        this.expectedLength = 0;
    }

    public byte getTag() {
        return this.tag;
    }

    public void setTag(byte tag) {
        this.tag = tag;
    }

    public Value getValue() {
        return this.value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TLV[ ");
        sb.append(Asn1StringUtils.dumpByte(this.tag)).append(", ");
        sb.append(this.length).append(", ");
        sb.append(this.value.toString());
        sb.append("]");
        return sb.toString();
    }

    public int getSize() {
        return 1 + this.lengthNbBytes + this.length;
    }

    public static int getNbBytes(int length) {
        if (length >= 0) {
            if (length < 128) {
                return 1;
            }
            if (length < 256) {
                return 2;
            }
            if (length < 65536) {
                return 3;
            }
            if (length < 0x1000000) {
                return 4;
            }
            return 5;
        }
        return 5;
    }

    public static byte[] getBytes(int length) {
        byte[] bytes = new byte[TLV.getNbBytes(length)];
        if (length >= 0) {
            if (length < 128) {
                bytes[0] = (byte)length;
            } else if (length < 256) {
                bytes[0] = -127;
                bytes[1] = (byte)length;
            } else if (length < 65536) {
                bytes[0] = -126;
                bytes[1] = (byte)(length >> 8);
                bytes[2] = (byte)(length & 0xFF);
            } else if (length < 0x1000000) {
                bytes[0] = -125;
                bytes[1] = (byte)(length >> 16);
                bytes[2] = (byte)(length >> 8 & 0xFF);
                bytes[3] = (byte)(length & 0xFF);
            } else {
                bytes[0] = -124;
                bytes[1] = (byte)(length >> 24);
                bytes[2] = (byte)(length >> 16 & 0xFF);
                bytes[3] = (byte)(length >> 8 & 0xFF);
                bytes[4] = (byte)(length & 0xFF);
            }
        } else {
            bytes[0] = -124;
            bytes[1] = (byte)(length >> 24);
            bytes[2] = (byte)(length >> 16 & 0xFF);
            bytes[3] = (byte)(length >> 8 & 0xFF);
            bytes[4] = (byte)(length & 0xFF);
        }
        return bytes;
    }

    public TLV getParent() {
        return this.parent;
    }

    public void setParent(TLV parent) {
        this.parent = parent;
    }

    public int getExpectedLength() {
        return this.expectedLength;
    }

    public void setExpectedLength(int expectedLength) {
        this.expectedLength = expectedLength;
    }

    public int getLengthNbBytes() {
        return this.lengthNbBytes;
    }

    public void setLengthNbBytes(int lengthNbBytes) {
        this.lengthNbBytes = lengthNbBytes;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLengthBytesRead() {
        return this.LengthBytesRead;
    }

    public void setLengthBytesRead(int lengthBytesRead) {
        this.LengthBytesRead = lengthBytesRead;
    }

    public void incLengthBytesRead() {
        ++this.LengthBytesRead;
    }
}

