/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.der;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERSequence;

public class DERTaggedObject
implements DEREncodable {
    protected int tag;
    protected boolean empty = false;
    protected boolean explicit = true;
    protected DEREncodable obj;
    private byte[] bytes;

    public DERTaggedObject(int tag) {
        this(false, tag, new DERSequence());
    }

    public DERTaggedObject(int tag, DEREncodable obj) {
        this.explicit = true;
        this.tag = tag;
        this.obj = obj;
    }

    public DERTaggedObject(boolean explicit, int tag, DEREncodable obj) {
        this.explicit = explicit;
        this.tag = tag;
        this.obj = obj;
    }

    public DERTaggedObject(boolean explicit, int tag, DEREncodable obj, byte[] bytes) {
        this.explicit = explicit;
        this.tag = tag;
        this.obj = obj;
        this.bytes = bytes;
    }

    public byte[] getOctets() {
        return this.bytes;
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getObject() {
        if (this.obj != null) {
            return this.obj;
        }
        return null;
    }

    public void encode(ASN1OutputStream out) throws IOException {
        if (!this.empty) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ASN1OutputStream aos = new ASN1OutputStream(baos);
            aos.writeObject(this.obj);
            aos.close();
            byte[] bytes = baos.toByteArray();
            if (this.explicit) {
                out.writeEncoded(0xA0 | this.tag, bytes);
            } else {
                bytes[0] = (bytes[0] & 0x20) != 0 ? (byte)(0xA0 | this.tag) : (byte)(0x80 | this.tag);
                out.write(bytes);
            }
        } else {
            out.writeEncoded(0xA0 | this.tag, new byte[0]);
        }
    }
}

