/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.util;

import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.i18n.I18n;

public final class IntegerDecoder {
    private static final int[] MASK = new int[]{255, 65535, 0xFFFFFF, -1};

    private IntegerDecoder() {
    }

    public static int parse(Value value, int min, int max) throws IntegerDecoderException {
        int result = 0;
        byte[] bytes = value.getData();
        if (bytes == null || bytes.length == 0) {
            throw new IntegerDecoderException(I18n.err((I18n)I18n.ERR_00036_0_BYTES_LONG_INTEGER, (Object[])new Object[0]));
        }
        if (bytes.length > 4) {
            throw new IntegerDecoderException(I18n.err((I18n)I18n.ERR_00037_ABOVE_4_BYTES_INTEGER, (Object[])new Object[0]));
        }
        for (int i = 0; i < bytes.length && i < 5; ++i) {
            result = result << 8 | bytes[i] & 0xFF;
        }
        if ((bytes[0] & 0x80) == 128) {
            result = -(~result + 1 & MASK[bytes.length - 1]);
        }
        if (result >= min && result <= max) {
            return result;
        }
        throw new IntegerDecoderException(I18n.err((I18n)I18n.ERR_00038_VALUE_NOT_IN_RANGE, (Object[])new Object[]{min, max}));
    }

    public static int parse(Value value) throws IntegerDecoderException {
        return IntegerDecoder.parse(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }
}

